/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorReply;
import org.projectfloodlight.openflow.protocol.OFFlowUpdateEvent;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorReplyVer15;

public class OFFlowMonitorReplyVer15Test {
    OFFactory factory;
    static final byte[] FLOW_MONITOR_REPLY_SERIALIZED = new byte[]{6, 19, 0, 20, 18, 52, 86, 120, 0, 16, 0, 1, 0, 0, 0, 0, 0, 4, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowMonitorReply.Builder builder = this.factory.buildFlowMonitorReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowMonitorReplyEntry().setEvent(OFFlowUpdateEvent.ADDED).build())).build();
        OFFlowMonitorReply flowMonitorReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowMonitorReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MONITOR_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowMonitorReply.Builder builder = this.factory.buildFlowMonitorReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowMonitorReplyEntry().setEvent(OFFlowUpdateEvent.ADDED).build())).build();
        OFFlowMonitorReply flowMonitorReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_MONITOR_REPLY_SERIALIZED);
        OFFlowMonitorReply flowMonitorReplyRead = OFFlowMonitorReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MONITOR_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowMonitorReplyBuilt, (Object)flowMonitorReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_MONITOR_REPLY_SERIALIZED);
        OFFlowMonitorReply flowMonitorReply = OFFlowMonitorReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MONITOR_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowMonitorReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MONITOR_REPLY_SERIALIZED));
    }
}

