/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFDescStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] DESC_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 16, 18, 52, 86, 120, 0, 0, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFDescStatsRequest.Builder builder = this.factory.buildDescStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).build();
        OFDescStatsRequest descStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        descStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)DESC_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFDescStatsRequest.Builder builder = this.factory.buildDescStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).build();
        OFDescStatsRequest descStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])DESC_STATS_REQUEST_SERIALIZED);
        OFDescStatsRequest descStatsRequestRead = OFDescStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)DESC_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)descStatsRequestBuilt, (Object)descStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])DESC_STATS_REQUEST_SERIALIZED);
        OFDescStatsRequest descStatsRequest = OFDescStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)DESC_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        descStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)DESC_STATS_REQUEST_SERIALIZED));
    }
}

