/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.ver14.OFFactoryVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortStatusVer14;

public class OFPortStatusVer14Test {
    OFFactory factory;
    static final byte[] PORT_STATUS_SERIALIZED = new byte[]{5, 12, 0, 88, 18, 52, 86, 120, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 72, 0, 0, 1, 2, 3, 4, 5, 6, 0, 0, 102, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 2, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 8, 0, 0, 0, 10, 0, 0, 0, 20};

    @Before
    public void setup() {
        this.factory = OFFactoryVer14.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATUS_SERIALIZED);
        OFPortStatus portStatus = OFPortStatusVer14.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATUS_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATUS_SERIALIZED));
    }
}

