// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmMetadataMaskedVer15 implements OFOxmMetadataMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmMetadataMaskedVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 20;

        private final static OFMetadata DEFAULT_VALUE = OFMetadata.NONE;
        private final static OFMetadata DEFAULT_VALUE_MASK = OFMetadata.NONE;

    // OF message fields
    private final OFMetadata value;
    private final OFMetadata mask;
//
    // Immutable default instance
    final static OFOxmMetadataMaskedVer15 DEFAULT = new OFOxmMetadataMaskedVer15(
        DEFAULT_VALUE, DEFAULT_VALUE_MASK
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmMetadataMaskedVer15(OFMetadata value, OFMetadata mask) {
        if(value == null) {
            throw new NullPointerException("OFOxmMetadataMaskedVer15: property value cannot be null");
        }
        if(mask == null) {
            throw new NullPointerException("OFOxmMetadataMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0x80000510L;
    }

    @Override
    public OFMetadata getValue() {
        return value;
    }

    @Override
    public OFMetadata getMask() {
        return mask;
    }

    @Override
    public MatchField<OFMetadata> getMatchField() {
        return MatchField.METADATA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    public OFOxm<OFMetadata> getCanonical() {
        if (OFMetadata.NO_MASK.equals(mask)) {
            return new OFOxmMetadataVer15(value);
        } else if(OFMetadata.FULL_MASK.equals(mask)) {
            return null;
        } else {
            return this;
        }
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFOxmMetadataMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmMetadataMasked.Builder {
        final OFOxmMetadataMaskedVer15 parentMessage;

        // OF message fields
        private boolean valueSet;
        private OFMetadata value;
        private boolean maskSet;
        private OFMetadata mask;

        BuilderWithParent(OFOxmMetadataMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0x80000510L;
    }

    @Override
    public OFMetadata getValue() {
        return value;
    }

    @Override
    public OFOxmMetadataMasked.Builder setValue(OFMetadata value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFMetadata getMask() {
        return mask;
    }

    @Override
    public OFOxmMetadataMasked.Builder setMask(OFMetadata mask) {
        this.mask = mask;
        this.maskSet = true;
        return this;
    }
    @Override
    public MatchField<OFMetadata> getMatchField() {
        return MatchField.METADATA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFMetadata> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFOxmMetadataMasked build() {
                OFMetadata value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");
                OFMetadata mask = this.maskSet ? this.mask : parentMessage.mask;
                if(mask == null)
                    throw new NullPointerException("Property mask must not be null");

                //
                return new OFOxmMetadataMaskedVer15(
                    value,
                    mask
                );
        }

    }

    static class Builder implements OFOxmMetadataMasked.Builder {
        // OF message fields
        private boolean valueSet;
        private OFMetadata value;
        private boolean maskSet;
        private OFMetadata mask;

    @Override
    public long getTypeLen() {
        return 0x80000510L;
    }

    @Override
    public OFMetadata getValue() {
        return value;
    }

    @Override
    public OFOxmMetadataMasked.Builder setValue(OFMetadata value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFMetadata getMask() {
        return mask;
    }

    @Override
    public OFOxmMetadataMasked.Builder setMask(OFMetadata mask) {
        this.mask = mask;
        this.maskSet = true;
        return this;
    }
    @Override
    public MatchField<OFMetadata> getMatchField() {
        return MatchField.METADATA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFMetadata> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFOxmMetadataMasked build() {
            OFMetadata value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");
            OFMetadata mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if(mask == null)
                throw new NullPointerException("Property mask must not be null");


            return new OFOxmMetadataMaskedVer15(
                    value,
                    mask
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmMetadataMasked> {
        @Override
        public OFOxmMetadataMasked readFrom(ByteBuf bb) throws OFParseError {
            // fixed value property typeLen == 0x80000510L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0x80000510)
                throw new OFParseError("Wrong typeLen: Expected=0x80000510L(0x80000510L), got="+typeLen);
            OFMetadata value = OFMetadata.read8Bytes(bb);
            OFMetadata mask = OFMetadata.read8Bytes(bb);

            OFOxmMetadataMaskedVer15 oxmMetadataMaskedVer15 = new OFOxmMetadataMaskedVer15(
                    value,
                      mask
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmMetadataMaskedVer15);
            return oxmMetadataMaskedVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmMetadataMaskedVer15Funnel FUNNEL = new OFOxmMetadataMaskedVer15Funnel();
    static class OFOxmMetadataMaskedVer15Funnel implements Funnel<OFOxmMetadataMaskedVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmMetadataMaskedVer15 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0x80000510L
            sink.putInt((int) 0x80000510);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmMetadataMaskedVer15> {
        @Override
        public void write(ByteBuf bb, OFOxmMetadataMaskedVer15 message) {
            // fixed value property typeLen = 0x80000510L
            bb.writeInt((int) 0x80000510);
            message.value.write8Bytes(bb);
            message.mask.write8Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmMetadataMaskedVer15(");
        b.append("value=").append(value);
        b.append(", ");
        b.append("mask=").append(mask);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmMetadataMaskedVer15 other = (OFOxmMetadataMaskedVer15) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        if (mask == null) {
            if (other.mask != null)
                return false;
        } else if (!mask.equals(other.mask))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        result = prime * result + ((mask == null) ? 0 : mask.hashCode());
        return result;
    }

}
