/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class StringByteSerializer {
    public static String readFrom(ByteBuf data, int length) {
        byte[] stringBytes = new byte[length];
        data.readBytes(stringBytes);
        int index = 0;
        for (byte b : stringBytes) {
            if (0 == b) break;
            ++index;
        }
        return new String(Arrays.copyOf(stringBytes, index), Charset.forName("ascii"));
    }

    public static void writeTo(ByteBuf data, int length, String value) {
        try {
            byte[] name = value.getBytes("ASCII");
            if (name.length < length) {
                data.writeBytes(name);
                for (int i = name.length; i < length; ++i) {
                    data.writeByte(0);
                }
            } else {
                data.writeBytes(name, 0, length - 1);
                data.writeByte(0);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

