/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class VFI
implements OFValueType<VFI> {
    private static final short ZERO_VAL = 0;
    static final int LENGTH = 2;
    public static final VFI ZERO = new VFI(0);
    public static final VFI NO_MASK = new VFI(-1);
    public static final VFI FULL_MASK = ZERO;
    private final short vfi;

    private VFI(short vfi) {
        this.vfi = vfi;
    }

    public static VFI ofVfi(int vfi) {
        if (vfi == VFI.NO_MASK.vfi) {
            return NO_MASK;
        }
        if (vfi == 0) {
            return ZERO;
        }
        return new VFI((short)vfi);
    }

    public short getVfi() {
        return this.vfi;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vfi;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VFI other = (VFI)obj;
        return this.vfi == other.vfi;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.vfi);
    }

    @Override
    public int getLength() {
        return 2;
    }

    public void write2Bytes(ByteBuf c) {
        c.writeShort((int)this.vfi);
    }

    public static VFI read2Bytes(ByteBuf c) throws OFParseError {
        return VFI.ofVfi(c.readShort());
    }

    @Override
    public VFI applyMask(VFI mask) {
        return VFI.ofVfi(this.vfi & mask.vfi);
    }

    @Override
    public int compareTo(VFI o) {
        return Integer.compare(this.vfi & 0xFFFF, o.vfi & 0xFFFF);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.vfi);
    }
}

