/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.types.OFValueType;

public class U8
implements Writeable,
OFValueType<U8> {
    private static final byte ZERO_VAL = 0;
    public static final U8 ZERO = new U8(0);
    private static final byte NO_MASK_VAL = -1;
    public static final U8 NO_MASK = new U8(-1);
    public static final U8 FULL_MASK = ZERO;
    private final byte raw;
    public static final Reader READER = new Reader();

    private U8(byte raw) {
        this.raw = raw;
    }

    public static final U8 of(short value) {
        if (value == 0) {
            return ZERO;
        }
        if (value == -1) {
            return NO_MASK;
        }
        return new U8(U8.t(value));
    }

    public static final U8 ofRaw(byte value) {
        return new U8(value);
    }

    public short getValue() {
        return U8.f(this.raw);
    }

    public byte getRaw() {
        return this.raw;
    }

    public String toString() {
        return String.format("0x%02x", this.raw);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.raw;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        U8 other = (U8)obj;
        return this.raw == other.raw;
    }

    @Override
    public void writeTo(ByteBuf bb) {
        bb.writeByte((int)this.raw);
    }

    public static short f(byte i) {
        return (short)(i & 0xFF);
    }

    public static byte t(short l) {
        return (byte)l;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public U8 applyMask(U8 mask) {
        return U8.ofRaw((byte)(this.raw & mask.raw));
    }

    @Override
    public int compareTo(U8 o) {
        return UnsignedBytes.compare((byte)this.raw, (byte)o.raw);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte(this.raw);
    }

    private static class Reader
    implements OFMessageReader<U8> {
        private Reader() {
        }

        @Override
        public U8 readFrom(ByteBuf bb) throws OFParseError {
            return new U8(bb.readByte());
        }
    }
}

