/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropWriteCopyfieldMiss;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropWriteCopyfieldMissVer15
implements OFTableFeaturePropWriteCopyfieldMiss {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropWriteCopyfieldMissVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U32> DEFAULT_OXM_IDS = ImmutableList.of();
    private final List<U32> oxmIds;
    static final OFTableFeaturePropWriteCopyfieldMissVer15 DEFAULT = new OFTableFeaturePropWriteCopyfieldMissVer15(DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropWriteCopyfieldMissVer15Funnel FUNNEL = new OFTableFeaturePropWriteCopyfieldMissVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropWriteCopyfieldMissVer15(List<U32> oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFTableFeaturePropWriteCopyfieldMissVer15: property oxmIds cannot be null");
        }
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public List<U32> getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTableFeaturePropWriteCopyfieldMiss.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropWriteCopyfieldMissVer15(");
        b.append("oxmIds=").append(this.oxmIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropWriteCopyfieldMissVer15 other = (OFTableFeaturePropWriteCopyfieldMissVer15)obj;
        return !(this.oxmIds == null ? other.oxmIds != null : !this.oxmIds.equals(other.oxmIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmIds == null ? 0 : this.oxmIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropWriteCopyfieldMissVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropWriteCopyfieldMissVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.oxmIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropWriteCopyfieldMissVer15Funnel
    implements Funnel<OFTableFeaturePropWriteCopyfieldMissVer15> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropWriteCopyfieldMissVer15Funnel() {
        }

        public void funnel(OFTableFeaturePropWriteCopyfieldMissVer15 message, PrimitiveSink sink) {
            sink.putShort((short)19);
            FunnelUtils.putList(message.oxmIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropWriteCopyfieldMiss> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropWriteCopyfieldMiss readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=0x13(0x13), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> oxmIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            OFTableFeaturePropWriteCopyfieldMissVer15 tableFeaturePropWriteCopyfieldMissVer15 = new OFTableFeaturePropWriteCopyfieldMissVer15(oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropWriteCopyfieldMissVer15);
            }
            return tableFeaturePropWriteCopyfieldMissVer15;
        }
    }

    static class Builder
    implements OFTableFeaturePropWriteCopyfieldMiss.Builder {
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropWriteCopyfieldMiss.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropWriteCopyfieldMiss build() {
            List<U32> oxmIds;
            List<U32> list = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropWriteCopyfieldMissVer15(oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropWriteCopyfieldMiss.Builder {
        final OFTableFeaturePropWriteCopyfieldMissVer15 parentMessage;
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        BuilderWithParent(OFTableFeaturePropWriteCopyfieldMissVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropWriteCopyfieldMiss.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropWriteCopyfieldMiss build() {
            List oxmIds;
            List list = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropWriteCopyfieldMissVer15(oxmIds);
        }
    }
}

