/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFTableFeatureFlag;

public class OFTableFeatureFlagSerializerVer15 {
    public static final int INGRESS_TABLE_VAL = 1;
    public static final int EGRESS_TABLE_VAL = 2;
    public static final int FIRST_EGRESS_VAL = 16;

    public static Set<OFTableFeatureFlag> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFTableFeatureFlagSerializerVer15.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFTableFeatureFlag> set) {
        bb.writeInt(OFTableFeatureFlagSerializerVer15.toWireValue(set));
    }

    public static void putTo(Set<OFTableFeatureFlag> set, PrimitiveSink sink) {
        sink.putInt(OFTableFeatureFlagSerializerVer15.toWireValue(set));
    }

    public static Set<OFTableFeatureFlag> ofWireValue(int val) {
        EnumSet<OFTableFeatureFlag> set = EnumSet.noneOf(OFTableFeatureFlag.class);
        if ((val & 1) != 0) {
            set.add(OFTableFeatureFlag.INGRESS_TABLE);
        }
        if ((val & 2) != 0) {
            set.add(OFTableFeatureFlag.EGRESS_TABLE);
        }
        if ((val & 0x10) != 0) {
            set.add(OFTableFeatureFlag.FIRST_EGRESS);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFTableFeatureFlag> set) {
        int wireValue = 0;
        block5: for (OFTableFeatureFlag e : set) {
            switch (e) {
                case INGRESS_TABLE: {
                    wireValue |= 1;
                    continue block5;
                }
                case EGRESS_TABLE: {
                    wireValue |= 2;
                    continue block5;
                }
                case FIRST_EGRESS: {
                    wireValue |= 0x10;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFTableFeatureFlag in version 1.5: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

