/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableConfig;
import org.projectfloodlight.openflow.protocol.OFTableDesc;
import org.projectfloodlight.openflow.protocol.OFTableModProp;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFTableConfigSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableModPropVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableDescVer15
implements OFTableDesc {
    private static final Logger logger = LoggerFactory.getLogger(OFTableDescVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final Set<OFTableConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final List<OFTableModProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final TableId tableId;
    private final Set<OFTableConfig> config;
    private final List<OFTableModProp> properties;
    static final OFTableDescVer15 DEFAULT = new OFTableDescVer15(DEFAULT_TABLE_ID, DEFAULT_CONFIG, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFTableDescVer15Funnel FUNNEL = new OFTableDescVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableDescVer15(TableId tableId, Set<OFTableConfig> config, List<OFTableModProp> properties) {
        if (tableId == null) {
            throw new NullPointerException("OFTableDescVer15: property tableId cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFTableDescVer15: property config cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFTableDescVer15: property properties cannot be null");
        }
        this.tableId = tableId;
        this.config = config;
        this.properties = properties;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public Set<OFTableConfig> getConfig() {
        return this.config;
    }

    @Override
    public List<OFTableModProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTableDesc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableDescVer15(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableDescVer15 other = (OFTableDescVer15)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableDescVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableDescVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.tableId.writeByte(bb);
            bb.writeZero(1);
            OFTableConfigSerializerVer15.writeTo(bb, message.config);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableDescVer15Funnel
    implements Funnel<OFTableDescVer15> {
        private static final long serialVersionUID = 1L;

        OFTableDescVer15Funnel() {
        }

        public void funnel(OFTableDescVer15 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            OFTableConfigSerializerVer15.putTo(message.config, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableDesc> {
        Reader() {
        }

        @Override
        public OFTableDesc readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(1);
            Set<OFTableConfig> config = OFTableConfigSerializerVer15.readFrom(bb);
            List<OFTableModProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTableModPropVer15.READER);
            OFTableDescVer15 tableDescVer15 = new OFTableDescVer15(tableId, config, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableDescVer15);
            }
            return tableDescVer15;
        }
    }

    static class Builder
    implements OFTableDesc.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private Set<OFTableConfig> config;
        private boolean propertiesSet;
        private List<OFTableModProp> properties;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableDesc.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Set<OFTableConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFTableDesc.Builder setConfig(Set<OFTableConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public List<OFTableModProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableDesc.Builder setProperties(List<OFTableModProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableDesc build() {
            List<OFTableModProp> properties;
            Set<OFTableConfig> config;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            Set<OFTableConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            List<OFTableModProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableDescVer15(tableId, config, properties);
        }
    }

    static class BuilderWithParent
    implements OFTableDesc.Builder {
        final OFTableDescVer15 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean configSet;
        private Set<OFTableConfig> config;
        private boolean propertiesSet;
        private List<OFTableModProp> properties;

        BuilderWithParent(OFTableDescVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableDesc.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Set<OFTableConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFTableDesc.Builder setConfig(Set<OFTableConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public List<OFTableModProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableDesc.Builder setProperties(List<OFTableModProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableDesc build() {
            List properties;
            Set config;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableDescVer15(tableId, config, properties);
        }
    }
}

