/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.ver15.OFAggregateStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeaturesStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFExperimenterStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowLightweightStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupFeaturesStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterConfigStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterFeaturesStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableFeaturesStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableStatsRequestVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsRequestVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsRequestVer15() {
    }

    static class Reader
    implements OFMessageReader<OFStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFStatsRequest<?> readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsRequestVer15.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsRequestVer15.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsRequestVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsRequestVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsRequestVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsRequestVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsRequestVer15.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsRequestVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFMeterConfigStatsRequestVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFMeterFeaturesStatsRequestVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFMeterStatsRequestVer15.READER.readFrom(bb);
                }
                case 13: {
                    return OFPortDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 12: {
                    return OFTableFeaturesStatsRequestVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFQueueDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 14: {
                    return OFTableDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 19: {
                    return OFBundleFeaturesStatsRequestVer15.READER.readFrom(bb);
                }
                case 18: {
                    return OFControllerStatusStatsRequestVer15.READER.readFrom(bb);
                }
                case 17: {
                    return OFFlowLightweightStatsRequestVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFFlowMonitorRequestVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer15: " + statsType);
        }
    }
}

