/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFControllerRoleReason;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFRoleProp;
import org.projectfloodlight.openflow.protocol.OFRoleStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerRoleReasonSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerRoleSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRolePropVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFRoleStatusVer15
implements OFRoleStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFRoleStatusVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_GENERATION_ID = U64.ZERO;
    private static final List<OFRoleProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final OFControllerRole role;
    private final OFControllerRoleReason reason;
    private final U64 generationId;
    private final List<OFRoleProp> properties;
    static final Reader READER = new Reader();
    static final OFRoleStatusVer15Funnel FUNNEL = new OFRoleStatusVer15Funnel();
    static final Writer WRITER = new Writer();

    OFRoleStatusVer15(long xid, OFControllerRole role, OFControllerRoleReason reason, U64 generationId, List<OFRoleProp> properties) {
        if (role == null) {
            throw new NullPointerException("OFRoleStatusVer15: property role cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFRoleStatusVer15: property reason cannot be null");
        }
        if (generationId == null) {
            throw new NullPointerException("OFRoleStatusVer15: property generationId cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFRoleStatusVer15: property properties cannot be null");
        }
        this.xid = xid;
        this.role = role;
        this.reason = reason;
        this.generationId = generationId;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ROLE_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFControllerRole getRole() {
        return this.role;
    }

    @Override
    public OFControllerRoleReason getReason() {
        return this.reason;
    }

    @Override
    public U64 getGenerationId() {
        return this.generationId;
    }

    @Override
    public List<OFRoleProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFRoleStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFRoleStatusVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("generationId=").append(this.generationId);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRoleStatusVer15 other = (OFRoleStatusVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRoleStatusVer15 other = (OFRoleStatusVer15)obj;
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFRoleStatusVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFRoleStatusVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(30);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            OFControllerRoleSerializerVer15.writeTo(bb, message.role);
            OFControllerRoleReasonSerializerVer15.writeTo(bb, message.reason);
            bb.writeZero(3);
            bb.writeLong(message.generationId.getValue());
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFRoleStatusVer15Funnel
    implements Funnel<OFRoleStatusVer15> {
        private static final long serialVersionUID = 1L;

        OFRoleStatusVer15Funnel() {
        }

        public void funnel(OFRoleStatusVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)30);
            sink.putLong(message.xid);
            OFControllerRoleSerializerVer15.putTo(message.role, sink);
            OFControllerRoleReasonSerializerVer15.putTo(message.reason, sink);
            message.generationId.putTo(sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFRoleStatus> {
        Reader() {
        }

        @Override
        public OFRoleStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 30) {
                throw new OFParseError("Wrong type: Expected=OFType.ROLE_STATUS(30), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFControllerRole role = OFControllerRoleSerializerVer15.readFrom(bb);
            OFControllerRoleReason reason = OFControllerRoleReasonSerializerVer15.readFrom(bb);
            bb.skipBytes(3);
            U64 generationId = U64.ofRaw(bb.readLong());
            List<OFRoleProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFRolePropVer15.READER);
            OFRoleStatusVer15 roleStatusVer15 = new OFRoleStatusVer15(xid, role, reason, generationId, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)roleStatusVer15);
            }
            return roleStatusVer15;
        }
    }

    static class Builder
    implements OFRoleStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean reasonSet;
        private OFControllerRoleReason reason;
        private boolean generationIdSet;
        private U64 generationId;
        private boolean propertiesSet;
        private List<OFRoleProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFRoleStatus.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFControllerRoleReason getReason() {
            return this.reason;
        }

        @Override
        public OFRoleStatus.Builder setReason(OFControllerRoleReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleStatus.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public List<OFRoleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFRoleStatus.Builder setProperties(List<OFRoleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFRoleStatus build() {
            List<OFRoleProp> properties;
            U64 generationId;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : DEFAULT_GENERATION_ID;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            List<OFRoleProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFRoleStatusVer15(xid, this.role, this.reason, generationId, properties);
        }
    }

    static class BuilderWithParent
    implements OFRoleStatus.Builder {
        final OFRoleStatusVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean reasonSet;
        private OFControllerRoleReason reason;
        private boolean generationIdSet;
        private U64 generationId;
        private boolean propertiesSet;
        private List<OFRoleProp> properties;

        BuilderWithParent(OFRoleStatusVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ROLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRoleStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFRoleStatus.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFControllerRoleReason getReason() {
            return this.reason;
        }

        @Override
        public OFRoleStatus.Builder setReason(OFControllerRoleReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFRoleStatus.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public List<OFRoleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFRoleStatus.Builder setProperties(List<OFRoleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFRoleStatus build() {
            List properties;
            U64 generationId;
            OFControllerRoleReason reason;
            OFControllerRole role;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFControllerRole oFControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            OFControllerRoleReason oFControllerRoleReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : this.parentMessage.generationId;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFRoleStatusVer15(xid, role, reason, generationId, properties);
        }
    }
}

