/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueDescPropMaxRate;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueDescPropMaxRateVer15
implements OFQueueDescPropMaxRate {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueDescPropMaxRateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final int DEFAULT_RATE = 0;
    private final int rate;
    static final OFQueueDescPropMaxRateVer15 DEFAULT = new OFQueueDescPropMaxRateVer15(0);
    static final Reader READER = new Reader();
    static final OFQueueDescPropMaxRateVer15Funnel FUNNEL = new OFQueueDescPropMaxRateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFQueueDescPropMaxRateVer15(int rate) {
        this.rate = rate;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFQueueDescPropMaxRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueDescPropMaxRateVer15(");
        b.append("rate=").append(this.rate);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueDescPropMaxRateVer15 other = (OFQueueDescPropMaxRateVer15)obj;
        return this.rate == other.rate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rate;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueDescPropMaxRateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFQueueDescPropMaxRateVer15 message) {
            bb.writeShort(2);
            bb.writeShort(8);
            bb.writeShort((int)U16.t(message.rate));
            bb.writeZero(2);
        }
    }

    static class OFQueueDescPropMaxRateVer15Funnel
    implements Funnel<OFQueueDescPropMaxRateVer15> {
        private static final long serialVersionUID = 1L;

        OFQueueDescPropMaxRateVer15Funnel() {
        }

        public void funnel(OFQueueDescPropMaxRateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)8);
            sink.putInt(message.rate);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueDescPropMaxRate> {
        Reader() {
        }

        @Override
        public OFQueueDescPropMaxRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int rate = U16.f(bb.readShort());
            bb.skipBytes(2);
            OFQueueDescPropMaxRateVer15 queueDescPropMaxRateVer15 = new OFQueueDescPropMaxRateVer15(rate);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueDescPropMaxRateVer15);
            }
            return queueDescPropMaxRateVer15;
        }
    }

    static class Builder
    implements OFQueueDescPropMaxRate.Builder {
        private boolean rateSet;
        private int rate;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueueDescPropMaxRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueDescPropMaxRate build() {
            int rate = this.rateSet ? this.rate : 0;
            return new OFQueueDescPropMaxRateVer15(rate);
        }
    }

    static class BuilderWithParent
    implements OFQueueDescPropMaxRate.Builder {
        final OFQueueDescPropMaxRateVer15 parentMessage;
        private boolean rateSet;
        private int rate;

        BuilderWithParent(OFQueueDescPropMaxRateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueueDescPropMaxRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueDescPropMaxRate build() {
            int rate = this.rateSet ? this.rate : this.parentMessage.rate;
            return new OFQueueDescPropMaxRateVer15(rate);
        }
    }
}

