/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortReasonSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatusVer15
implements OFPortStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatusVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 56;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFPortReason reason;
    private final OFPortDesc desc;
    static final Reader READER = new Reader();
    static final OFPortStatusVer15Funnel FUNNEL = new OFPortStatusVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatusVer15(long xid, OFPortReason reason, OFPortDesc desc) {
        if (reason == null) {
            throw new NullPointerException("OFPortStatusVer15: property reason cannot be null");
        }
        if (desc == null) {
            throw new NullPointerException("OFPortStatusVer15: property desc cannot be null");
        }
        this.xid = xid;
        this.reason = reason;
        this.desc = desc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.PORT_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPortReason getReason() {
        return this.reason;
    }

    @Override
    public OFPortDesc getDesc() {
        return this.desc;
    }

    @Override
    public OFPortStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatusVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("desc=").append(this.desc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatusVer15 other = (OFPortStatusVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.desc == null ? other.desc != null : !this.desc.equals(other.desc));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatusVer15 other = (OFPortStatusVer15)obj;
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.desc == null ? other.desc != null : !this.desc.equals(other.desc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatusVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortStatusVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(12);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            OFPortReasonSerializerVer15.writeTo(bb, message.reason);
            bb.writeZero(7);
            message.desc.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortStatusVer15Funnel
    implements Funnel<OFPortStatusVer15> {
        private static final long serialVersionUID = 1L;

        OFPortStatusVer15Funnel() {
        }

        public void funnel(OFPortStatusVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)12);
            sink.putLong(message.xid);
            OFPortReasonSerializerVer15.putTo(message.reason, sink);
            message.desc.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatus> {
        Reader() {
        }

        @Override
        public OFPortStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 12) {
                throw new OFParseError("Wrong type: Expected=OFType.PORT_STATUS(12), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 56) {
                throw new OFParseError("Wrong length: Expected to be >= 56, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPortReason reason = OFPortReasonSerializerVer15.readFrom(bb);
            bb.skipBytes(7);
            OFPortDesc desc = OFPortDescVer15.READER.readFrom(bb);
            OFPortStatusVer15 portStatusVer15 = new OFPortStatusVer15(xid, reason, desc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatusVer15);
            }
            return portStatusVer15;
        }
    }

    static class Builder
    implements OFPortStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFPortDesc desc;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFPortDesc getDesc() {
            return this.desc;
        }

        @Override
        public OFPortStatus.Builder setDesc(OFPortDesc desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFPortStatus build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            if (!this.descSet) {
                throw new IllegalStateException("Property desc doesn't have default value -- must be set");
            }
            if (this.desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFPortStatusVer15(xid, this.reason, this.desc);
        }
    }

    static class BuilderWithParent
    implements OFPortStatus.Builder {
        final OFPortStatusVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFPortReason reason;
        private boolean descSet;
        private OFPortDesc desc;

        BuilderWithParent(OFPortStatusVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPortReason getReason() {
            return this.reason;
        }

        @Override
        public OFPortStatus.Builder setReason(OFPortReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFPortDesc getDesc() {
            return this.desc;
        }

        @Override
        public OFPortStatus.Builder setDesc(OFPortDesc desc) {
            this.desc = desc;
            this.descSet = true;
            return this;
        }

        @Override
        public OFPortStatus build() {
            OFPortDesc desc;
            OFPortReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPortReason oFPortReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFPortDesc oFPortDesc = desc = this.descSet ? this.desc : this.parentMessage.desc;
            if (desc == null) {
                throw new NullPointerException("Property desc must not be null");
            }
            return new OFPortStatusVer15(xid, reason, desc);
        }
    }
}

