/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortModPropType;
import org.projectfloodlight.openflow.types.U8;

public class OFPortModPropTypeSerializerVer15 {
    public static final short ETHERNET_VAL = 0;
    public static final short OPTICAL_VAL = 1;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFPortModPropType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortModPropTypeSerializerVer15.ofWireValue(U8.f(bb.readByte()));
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFPortModPropType e) {
        bb.writeByte((int)U8.t(OFPortModPropTypeSerializerVer15.toWireValue(e)));
    }

    public static void putTo(OFPortModPropType e, PrimitiveSink sink) {
        sink.putShort(OFPortModPropTypeSerializerVer15.toWireValue(e));
    }

    public static OFPortModPropType ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFPortModPropType.ETHERNET;
            }
            case 1: {
                return OFPortModPropType.OPTICAL;
            }
            case -1: {
                return OFPortModPropType.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFPortModPropType in version 1.5: " + val);
    }

    public static short toWireValue(OFPortModPropType e) {
        switch (e) {
            case ETHERNET: {
                return 0;
            }
            case OPTICAL: {
                return 1;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFPortModPropType in version 1.5: " + (Object)((Object)e));
    }
}

