/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsn;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnBreakoutVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnForwardErrorCorrectionVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnGenerationIdVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnMiscCapabilitiesVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnSffJsonVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnSpeedCapabilitiesVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescPropBsnUplinkVer15;
import org.projectfloodlight.openflow.types.U16;

abstract class OFPortDescPropBsnVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    public static final Reader READER = new Reader();

    OFPortDescPropBsnVer15() {
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsn> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsn readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 12) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            bb.readerIndex(start);
            switch (expType) {
                case 3: {
                    return OFPortDescPropBsnBreakoutVer15.READER.readFrom(bb);
                }
                case 2: {
                    return OFPortDescPropBsnForwardErrorCorrectionVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFPortDescPropBsnGenerationIdVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFPortDescPropBsnMiscCapabilitiesVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFPortDescPropBsnSffJsonVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortDescPropBsnSpeedCapabilitiesVer15.READER.readFrom(bb);
                }
                case 0: {
                    return OFPortDescPropBsnUplinkVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator expType of class OFPortDescPropBsnVer15: " + expType);
        }
    }
}

