/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnSffJson;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnSffJsonVer15
implements OFPortDescPropBsnSffJson {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnSffJsonVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    private static final byte[] DEFAULT_DATA_JSON = new byte[0];
    private final byte[] dataJson;
    static final OFPortDescPropBsnSffJsonVer15 DEFAULT = new OFPortDescPropBsnSffJsonVer15(DEFAULT_DATA_JSON);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnSffJsonVer15Funnel FUNNEL = new OFPortDescPropBsnSffJsonVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnSffJsonVer15(byte[] dataJson) {
        if (dataJson == null) {
            throw new NullPointerException("OFPortDescPropBsnSffJsonVer15: property dataJson cannot be null");
        }
        this.dataJson = dataJson;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 6L;
    }

    @Override
    public byte[] getDataJson() {
        return this.dataJson;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropBsnSffJson.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnSffJsonVer15(");
        b.append("dataJson=").append(Arrays.toString(this.dataJson));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnSffJsonVer15 other = (OFPortDescPropBsnSffJsonVer15)obj;
        return Arrays.equals(this.dataJson, other.dataJson);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dataJson);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnSffJsonVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnSffJsonVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(6035143);
            bb.writeInt(6);
            bb.writeBytes(message.dataJson);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortDescPropBsnSffJsonVer15Funnel
    implements Funnel<OFPortDescPropBsnSffJsonVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnSffJsonVer15Funnel() {
        }

        public void funnel(OFPortDescPropBsnSffJsonVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(6035143);
            sink.putInt(6);
            sink.putBytes(message.dataJson);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnSffJson> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnSffJson readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 6) {
                throw new OFParseError("Wrong expType: Expected=0x6L(0x6L), got=" + expType);
            }
            byte[] dataJson = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPortDescPropBsnSffJsonVer15 portDescPropBsnSffJsonVer15 = new OFPortDescPropBsnSffJsonVer15(dataJson);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnSffJsonVer15);
            }
            return portDescPropBsnSffJsonVer15;
        }
    }

    static class Builder
    implements OFPortDescPropBsnSffJson.Builder {
        private boolean dataJsonSet;
        private byte[] dataJson;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 6L;
        }

        @Override
        public OFPortDescPropBsnSffJson.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getDataJson() {
            return this.dataJson;
        }

        @Override
        public OFPortDescPropBsnSffJson.Builder setDataJson(byte[] dataJson) {
            this.dataJson = dataJson;
            this.dataJsonSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnSffJson build() {
            byte[] dataJson;
            byte[] byArray = dataJson = this.dataJsonSet ? this.dataJson : DEFAULT_DATA_JSON;
            if (dataJson == null) {
                throw new NullPointerException("Property dataJson must not be null");
            }
            return new OFPortDescPropBsnSffJsonVer15(dataJson);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnSffJson.Builder {
        final OFPortDescPropBsnSffJsonVer15 parentMessage;
        private boolean dataJsonSet;
        private byte[] dataJson;

        BuilderWithParent(OFPortDescPropBsnSffJsonVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 6L;
        }

        @Override
        public OFPortDescPropBsnSffJson.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getDataJson() {
            return this.dataJson;
        }

        @Override
        public OFPortDescPropBsnSffJson.Builder setDataJson(byte[] dataJson) {
            this.dataJson = dataJson;
            this.dataJsonSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnSffJson build() {
            byte[] dataJson;
            byte[] byArray = dataJson = this.dataJsonSet ? this.dataJson : this.parentMessage.dataJson;
            if (dataJson == null) {
                throw new NullPointerException("Property dataJson must not be null");
            }
            return new OFPortDescPropBsnSffJsonVer15(dataJson);
        }
    }
}

