/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanPcp;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmVlanPcpVer15
implements OFOxmVlanPcp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmVlanPcpVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final VlanPcp DEFAULT_VALUE = VlanPcp.NONE;
    private final VlanPcp value;
    static final OFOxmVlanPcpVer15 DEFAULT = new OFOxmVlanPcpVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmVlanPcpVer15Funnel FUNNEL = new OFOxmVlanPcpVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmVlanPcpVer15(VlanPcp value) {
        if (value == null) {
            throw new NullPointerException("OFOxmVlanPcpVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147487233L;
    }

    @Override
    public VlanPcp getValue() {
        return this.value;
    }

    @Override
    public MatchField<VlanPcp> getMatchField() {
        return MatchField.VLAN_PCP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VlanPcp> getCanonical() {
        return this;
    }

    @Override
    public VlanPcp getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmVlanPcp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmVlanPcpVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmVlanPcpVer15 other = (OFOxmVlanPcpVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmVlanPcpVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmVlanPcpVer15 message) {
            bb.writeInt(-2147480063);
            message.value.writeByte(bb);
        }
    }

    static class OFOxmVlanPcpVer15Funnel
    implements Funnel<OFOxmVlanPcpVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmVlanPcpVer15Funnel() {
        }

        public void funnel(OFOxmVlanPcpVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147480063);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmVlanPcp> {
        Reader() {
        }

        @Override
        public OFOxmVlanPcp readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147480063) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000e01L(0x80000e01L), got=" + typeLen);
            }
            VlanPcp value = VlanPcp.readByte(bb);
            OFOxmVlanPcpVer15 oxmVlanPcpVer15 = new OFOxmVlanPcpVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmVlanPcpVer15);
            }
            return oxmVlanPcpVer15;
        }
    }

    static class Builder
    implements OFOxmVlanPcp.Builder {
        private boolean valueSet;
        private VlanPcp value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147487233L;
        }

        @Override
        public VlanPcp getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanPcp.Builder setValue(VlanPcp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VlanPcp> getMatchField() {
            return MatchField.VLAN_PCP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VlanPcp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public VlanPcp getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmVlanPcp build() {
            VlanPcp value;
            VlanPcp vlanPcp = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmVlanPcpVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmVlanPcp.Builder {
        final OFOxmVlanPcpVer15 parentMessage;
        private boolean valueSet;
        private VlanPcp value;

        BuilderWithParent(OFOxmVlanPcpVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147487233L;
        }

        @Override
        public VlanPcp getValue() {
            return this.value;
        }

        @Override
        public OFOxmVlanPcp.Builder setValue(VlanPcp value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VlanPcp> getMatchField() {
            return MatchField.VLAN_PCP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VlanPcp> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public VlanPcp getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmVlanPcp build() {
            VlanPcp value;
            VlanPcp vlanPcp = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmVlanPcpVer15(value);
        }
    }
}

