/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthTypeMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmEthTypeVer15;
import org.projectfloodlight.openflow.types.EthType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEthTypeMaskedVer15
implements OFOxmEthTypeMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEthTypeMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final EthType DEFAULT_VALUE = EthType.NONE;
    private static final EthType DEFAULT_VALUE_MASK = EthType.NONE;
    private final EthType value;
    private final EthType mask;
    static final OFOxmEthTypeMaskedVer15 DEFAULT = new OFOxmEthTypeMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmEthTypeMaskedVer15Funnel FUNNEL = new OFOxmEthTypeMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEthTypeMaskedVer15(EthType value, EthType mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmEthTypeMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmEthTypeMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147486468L;
    }

    @Override
    public EthType getValue() {
        return this.value;
    }

    @Override
    public EthType getMask() {
        return this.mask;
    }

    @Override
    public MatchField<EthType> getMatchField() {
        return MatchField.ETH_TYPE;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<EthType> getCanonical() {
        if (EthType.NO_MASK.equals(this.mask)) {
            return new OFOxmEthTypeVer15(this.value);
        }
        if (EthType.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmEthTypeMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEthTypeMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEthTypeMaskedVer15 other = (OFOxmEthTypeMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEthTypeMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmEthTypeMaskedVer15 message) {
            bb.writeInt(-2147480828);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmEthTypeMaskedVer15Funnel
    implements Funnel<OFOxmEthTypeMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmEthTypeMaskedVer15Funnel() {
        }

        public void funnel(OFOxmEthTypeMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147480828);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEthTypeMasked> {
        Reader() {
        }

        @Override
        public OFOxmEthTypeMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147480828) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000b04L(0x80000b04L), got=" + typeLen);
            }
            EthType value = EthType.read2Bytes(bb);
            EthType mask = EthType.read2Bytes(bb);
            OFOxmEthTypeMaskedVer15 oxmEthTypeMaskedVer15 = new OFOxmEthTypeMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEthTypeMaskedVer15);
            }
            return oxmEthTypeMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmEthTypeMasked.Builder {
        private boolean valueSet;
        private EthType value;
        private boolean maskSet;
        private EthType mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147486468L;
        }

        @Override
        public EthType getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthTypeMasked.Builder setValue(EthType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public EthType getMask() {
            return this.mask;
        }

        @Override
        public OFOxmEthTypeMasked.Builder setMask(EthType mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<EthType> getMatchField() {
            return MatchField.ETH_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<EthType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmEthTypeMasked build() {
            EthType mask;
            EthType value;
            EthType ethType = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            EthType ethType2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmEthTypeMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmEthTypeMasked.Builder {
        final OFOxmEthTypeMaskedVer15 parentMessage;
        private boolean valueSet;
        private EthType value;
        private boolean maskSet;
        private EthType mask;

        BuilderWithParent(OFOxmEthTypeMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147486468L;
        }

        @Override
        public EthType getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthTypeMasked.Builder setValue(EthType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public EthType getMask() {
            return this.mask;
        }

        @Override
        public OFOxmEthTypeMasked.Builder setMask(EthType mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<EthType> getMatchField() {
            return MatchField.ETH_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<EthType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmEthTypeMasked build() {
            EthType mask;
            EthType value;
            EthType ethType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            EthType ethType2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmEthTypeMaskedVer15(value, mask);
        }
    }
}

