/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmActsetOutputMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmActsetOutputVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmActsetOutputMaskedVer15
implements OFOxmActsetOutputMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmActsetOutputMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private static final OFPort DEFAULT_VALUE_MASK = OFPort.ANY;
    private final OFPort value;
    private final OFPort mask;
    static final OFOxmActsetOutputMaskedVer15 DEFAULT = new OFOxmActsetOutputMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmActsetOutputMaskedVer15Funnel FUNNEL = new OFOxmActsetOutputMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmActsetOutputMaskedVer15(OFPort value, OFPort mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmActsetOutputMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmActsetOutputMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147505928L;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public OFPort getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFPort> getMatchField() {
        return MatchField.ACTSET_OUTPUT;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFPort> getCanonical() {
        if (OFPort.NO_MASK.equals(this.mask)) {
            return new OFOxmActsetOutputVer15(this.value);
        }
        if (OFPort.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmActsetOutputMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmActsetOutputMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmActsetOutputMaskedVer15 other = (OFOxmActsetOutputMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmActsetOutputMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmActsetOutputMaskedVer15 message) {
            bb.writeInt(-2147461368);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmActsetOutputMaskedVer15Funnel
    implements Funnel<OFOxmActsetOutputMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmActsetOutputMaskedVer15Funnel() {
        }

        public void funnel(OFOxmActsetOutputMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147461368);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmActsetOutputMasked> {
        Reader() {
        }

        @Override
        public OFOxmActsetOutputMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147461368) {
                throw new OFParseError("Wrong typeLen: Expected=0x80005708L(0x80005708L), got=" + typeLen);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFPort mask = OFPort.read4Bytes(bb);
            OFOxmActsetOutputMaskedVer15 oxmActsetOutputMaskedVer15 = new OFOxmActsetOutputMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmActsetOutputMaskedVer15);
            }
            return oxmActsetOutputMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmActsetOutputMasked.Builder {
        private boolean valueSet;
        private OFPort value;
        private boolean maskSet;
        private OFPort mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147505928L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmActsetOutputMasked.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmActsetOutputMasked.Builder setMask(OFPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.ACTSET_OUTPUT;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmActsetOutputMasked build() {
            OFPort mask;
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFPort oFPort2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmActsetOutputMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmActsetOutputMasked.Builder {
        final OFOxmActsetOutputMaskedVer15 parentMessage;
        private boolean valueSet;
        private OFPort value;
        private boolean maskSet;
        private OFPort mask;

        BuilderWithParent(OFOxmActsetOutputMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147505928L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmActsetOutputMasked.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmActsetOutputMasked.Builder setMask(OFPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.ACTSET_OUTPUT;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmActsetOutputMasked build() {
            OFPort mask;
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFPort oFPort2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmActsetOutputMaskedVer15(value, mask);
        }
    }
}

