/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterConfigStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterConfigStatsRequestVer15
implements OFMeterConfigStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterConfigStatsRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_METER_ID = 0L;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final long meterId;
    static final OFMeterConfigStatsRequestVer15 DEFAULT = new OFMeterConfigStatsRequestVer15(0L, DEFAULT_FLAGS, 0L);
    static final Reader READER = new Reader();
    static final OFMeterConfigStatsRequestVer15Funnel FUNNEL = new OFMeterConfigStatsRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFMeterConfigStatsRequestVer15(long xid, Set<OFStatsRequestFlags> flags, long meterId) {
        if (flags == null) {
            throw new NullPointerException("OFMeterConfigStatsRequestVer15: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.meterId = meterId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.METER_CONFIG;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public OFMeterConfigStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterConfigStatsRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("meterId=").append(this.meterId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterConfigStatsRequestVer15 other = (OFMeterConfigStatsRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.meterId == other.meterId;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterConfigStatsRequestVer15 other = (OFMeterConfigStatsRequestVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.meterId == other.meterId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterConfigStatsRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterConfigStatsRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(10);
            OFStatsRequestFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(U32.t(message.meterId));
            bb.writeZero(4);
        }
    }

    static class OFMeterConfigStatsRequestVer15Funnel
    implements Funnel<OFMeterConfigStatsRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFMeterConfigStatsRequestVer15Funnel() {
        }

        public void funnel(OFMeterConfigStatsRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)10);
            OFStatsRequestFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putLong(message.meterId);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterConfigStatsRequest> {
        Reader() {
        }

        @Override
        public OFMeterConfigStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 10) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.METER_CONFIG(10), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            long meterId = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFMeterConfigStatsRequestVer15 meterConfigStatsRequestVer15 = new OFMeterConfigStatsRequestVer15(xid, flags, meterId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterConfigStatsRequestVer15);
            }
            return meterConfigStatsRequestVer15;
        }
    }

    static class Builder
    implements OFMeterConfigStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean meterIdSet;
        private long meterId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterConfigStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.METER_CONFIG;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterConfigStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterConfigStatsRequest.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFMeterConfigStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : 0L;
            return new OFMeterConfigStatsRequestVer15(xid, flags, meterId);
        }
    }

    static class BuilderWithParent
    implements OFMeterConfigStatsRequest.Builder {
        final OFMeterConfigStatsRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean meterIdSet;
        private long meterId;

        BuilderWithParent(OFMeterConfigStatsRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterConfigStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.METER_CONFIG;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterConfigStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterConfigStatsRequest.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFMeterConfigStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            return new OFMeterConfigStatsRequestVer15(xid, flags, meterId);
        }
    }
}

