/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.OFStatTriggerFlags;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionStatTrigger;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatTriggerFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionStatTriggerVer15
implements OFInstructionStatTrigger {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionStatTriggerVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    private static final Set<OFStatTriggerFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFOxsList DEFAULT_THRESHOLDS = OFOxsList.EMPTY;
    private final Set<OFStatTriggerFlags> flags;
    private final OFOxsList thresholds;
    static final OFInstructionStatTriggerVer15 DEFAULT = new OFInstructionStatTriggerVer15(DEFAULT_FLAGS, DEFAULT_THRESHOLDS);
    static final Reader READER = new Reader();
    static final OFInstructionStatTriggerVer15Funnel FUNNEL = new OFInstructionStatTriggerVer15Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionStatTriggerVer15(Set<OFStatTriggerFlags> flags, OFOxsList thresholds) {
        if (flags == null) {
            throw new NullPointerException("OFInstructionStatTriggerVer15: property flags cannot be null");
        }
        if (thresholds == null) {
            throw new NullPointerException("OFInstructionStatTriggerVer15: property thresholds cannot be null");
        }
        this.flags = flags;
        this.thresholds = thresholds;
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.STAT_TRIGGER;
    }

    @Override
    public Set<OFStatTriggerFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFOxsList getThresholds() {
        return this.thresholds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFInstructionStatTrigger.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionStatTriggerVer15(");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("thresholds=").append(this.thresholds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionStatTriggerVer15 other = (OFInstructionStatTriggerVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.thresholds == null ? other.thresholds != null : !this.thresholds.equals(other.thresholds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.thresholds == null ? 0 : this.thresholds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionStatTriggerVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionStatTriggerVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(7);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            OFStatTriggerFlagsSerializerVer15.writeTo(bb, message.flags);
            message.thresholds.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFInstructionStatTriggerVer15Funnel
    implements Funnel<OFInstructionStatTriggerVer15> {
        private static final long serialVersionUID = 1L;

        OFInstructionStatTriggerVer15Funnel() {
        }

        public void funnel(OFInstructionStatTriggerVer15 message, PrimitiveSink sink) {
            sink.putShort((short)7);
            OFStatTriggerFlagsSerializerVer15.putTo(message.flags, sink);
            message.thresholds.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionStatTrigger> {
        Reader() {
        }

        @Override
        public OFInstructionStatTrigger readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 7) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.STAT_TRIGGER(7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFStatTriggerFlags> flags = OFStatTriggerFlagsSerializerVer15.readFrom(bb);
            OFOxsList thresholds = OFOxsList.readFrom(bb, length - (bb.readerIndex() - start), OFOxsVer15.READER);
            OFInstructionStatTriggerVer15 instructionStatTriggerVer15 = new OFInstructionStatTriggerVer15(flags, thresholds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionStatTriggerVer15);
            }
            return instructionStatTriggerVer15;
        }
    }

    static class Builder
    implements OFInstructionStatTrigger.Builder {
        private boolean flagsSet;
        private Set<OFStatTriggerFlags> flags;
        private boolean thresholdsSet;
        private OFOxsList thresholds;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.STAT_TRIGGER;
        }

        @Override
        public Set<OFStatTriggerFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFInstructionStatTrigger.Builder setFlags(Set<OFStatTriggerFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFOxsList getThresholds() {
            return this.thresholds;
        }

        @Override
        public OFInstructionStatTrigger.Builder setThresholds(OFOxsList thresholds) {
            this.thresholds = thresholds;
            this.thresholdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFInstructionStatTrigger build() {
            OFOxsList thresholds;
            Set<OFStatTriggerFlags> flags;
            Set<OFStatTriggerFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFOxsList oFOxsList = thresholds = this.thresholdsSet ? this.thresholds : DEFAULT_THRESHOLDS;
            if (thresholds == null) {
                throw new NullPointerException("Property thresholds must not be null");
            }
            return new OFInstructionStatTriggerVer15(flags, thresholds);
        }
    }

    static class BuilderWithParent
    implements OFInstructionStatTrigger.Builder {
        final OFInstructionStatTriggerVer15 parentMessage;
        private boolean flagsSet;
        private Set<OFStatTriggerFlags> flags;
        private boolean thresholdsSet;
        private OFOxsList thresholds;

        BuilderWithParent(OFInstructionStatTriggerVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.STAT_TRIGGER;
        }

        @Override
        public Set<OFStatTriggerFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFInstructionStatTrigger.Builder setFlags(Set<OFStatTriggerFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFOxsList getThresholds() {
            return this.thresholds;
        }

        @Override
        public OFInstructionStatTrigger.Builder setThresholds(OFOxsList thresholds) {
            this.thresholds = thresholds;
            this.thresholdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFInstructionStatTrigger build() {
            OFOxsList thresholds;
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFOxsList oFOxsList = thresholds = this.thresholdsSet ? this.thresholds : this.parentMessage.thresholds;
            if (thresholds == null) {
                throw new NullPointerException("Property thresholds must not be null");
            }
            return new OFInstructionStatTriggerVer15(flags, thresholds);
        }
    }
}

