/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupMod;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupAddVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupDeleteVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupInsertBucketVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupModifyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupRemoveBucketVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFGroupModVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    public static final Reader READER = new Reader();

    OFGroupModVer15() {
    }

    static class Reader
    implements OFMessageReader<OFGroupMod> {
        Reader() {
        }

        @Override
        public OFGroupMod readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 24) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFType.GROUP_MOD(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            U32.f(bb.readInt());
            short command = bb.readShort();
            bb.readerIndex(start);
            switch (command) {
                case 0: {
                    return OFGroupAddVer15.READER.readFrom(bb);
                }
                case 2: {
                    return OFGroupDeleteVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFGroupModifyVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFGroupInsertBucketVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFGroupRemoveBucketVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator command of class OFGroupModVer15: " + command);
        }
    }
}

