/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupBucketPropWatchGroup;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupBucketPropWatchGroupVer15
implements OFGroupBucketPropWatchGroup {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupBucketPropWatchGroupVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_WATCH = 0L;
    private final long watch;
    static final OFGroupBucketPropWatchGroupVer15 DEFAULT = new OFGroupBucketPropWatchGroupVer15(0L);
    static final Reader READER = new Reader();
    static final OFGroupBucketPropWatchGroupVer15Funnel FUNNEL = new OFGroupBucketPropWatchGroupVer15Funnel();
    static final Writer WRITER = new Writer();

    OFGroupBucketPropWatchGroupVer15(long watch) {
        this.watch = watch;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public long getWatch() {
        return this.watch;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFGroupBucketPropWatchGroup.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupBucketPropWatchGroupVer15(");
        b.append("watch=").append(this.watch);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupBucketPropWatchGroupVer15 other = (OFGroupBucketPropWatchGroupVer15)obj;
        return this.watch == other.watch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.watch ^ this.watch >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupBucketPropWatchGroupVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupBucketPropWatchGroupVer15 message) {
            bb.writeShort(2);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.watch));
        }
    }

    static class OFGroupBucketPropWatchGroupVer15Funnel
    implements Funnel<OFGroupBucketPropWatchGroupVer15> {
        private static final long serialVersionUID = 1L;

        OFGroupBucketPropWatchGroupVer15Funnel() {
        }

        public void funnel(OFGroupBucketPropWatchGroupVer15 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)8);
            sink.putLong(message.watch);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupBucketPropWatchGroup> {
        Reader() {
        }

        @Override
        public OFGroupBucketPropWatchGroup readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long watch = U32.f(bb.readInt());
            OFGroupBucketPropWatchGroupVer15 groupBucketPropWatchGroupVer15 = new OFGroupBucketPropWatchGroupVer15(watch);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupBucketPropWatchGroupVer15);
            }
            return groupBucketPropWatchGroupVer15;
        }
    }

    static class Builder
    implements OFGroupBucketPropWatchGroup.Builder {
        private boolean watchSet;
        private long watch;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getWatch() {
            return this.watch;
        }

        @Override
        public OFGroupBucketPropWatchGroup.Builder setWatch(long watch) {
            this.watch = watch;
            this.watchSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupBucketPropWatchGroup build() {
            long watch = this.watchSet ? this.watch : 0L;
            return new OFGroupBucketPropWatchGroupVer15(watch);
        }
    }

    static class BuilderWithParent
    implements OFGroupBucketPropWatchGroup.Builder {
        final OFGroupBucketPropWatchGroupVer15 parentMessage;
        private boolean watchSet;
        private long watch;

        BuilderWithParent(OFGroupBucketPropWatchGroupVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getWatch() {
            return this.watch;
        }

        @Override
        public OFGroupBucketPropWatchGroup.Builder setWatch(long watch) {
            this.watch = watch;
            this.watchSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupBucketPropWatchGroup build() {
            long watch = this.watchSet ? this.watch : this.parentMessage.watch;
            return new OFGroupBucketPropWatchGroupVer15(watch);
        }
    }
}

