/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.ChannelUtilsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowModFlagsSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowStatsEntryVer15
implements OFFlowStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 40;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_IDLE_TIMEOUT = 0;
    private static final int DEFAULT_HARD_TIMEOUT = 0;
    private static final Set<OFFlowModFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final int DEFAULT_IMPORTANCE = 0;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final Match DEFAULT_MATCH = OFFactoryVer15.MATCH_WILDCARD_ALL;
    private static final List<OFInstruction> DEFAULT_INSTRUCTIONS = ImmutableList.of();
    private final TableId tableId;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final Set<OFFlowModFlags> flags;
    private final int importance;
    private final U64 cookie;
    private final Match match;
    private final Stat stats;
    private final List<OFInstruction> instructions;
    static final Reader READER = new Reader();
    static final OFFlowStatsEntryVer15Funnel FUNNEL = new OFFlowStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFFlowStatsEntryVer15(TableId tableId, int priority, int idleTimeout, int hardTimeout, Set<OFFlowModFlags> flags, int importance, U64 cookie, Match match, Stat stats, List<OFInstruction> instructions) {
        if (tableId == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property tableId cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property flags cannot be null");
        }
        if (cookie == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property cookie cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property match cannot be null");
        }
        if (stats == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property stats cannot be null");
        }
        if (instructions == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property instructions cannot be null");
        }
        this.tableId = tableId;
        this.priority = priority;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.flags = flags;
        this.importance = importance;
        this.cookie = cookie;
        this.match = match;
        this.stats = stats;
        this.instructions = instructions;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getDurationSec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public long getDurationNsec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public Set<OFFlowModFlags> getFlags() {
        return this.flags;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public U64 getPacketCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public U64 getByteCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public List<OFInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public List<OFAction> getActions() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.5");
    }

    @Override
    public int getImportance() {
        return this.importance;
    }

    @Override
    public Stat getStats() {
        return this.stats;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFFlowStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowStatsEntryVer15(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("idleTimeout=").append(this.idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(this.hardTimeout);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("importance=").append(this.importance);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("stats=").append(this.stats);
        b.append(", ");
        b.append("instructions=").append(this.instructions);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowStatsEntryVer15 other = (OFFlowStatsEntryVer15)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.importance != other.importance) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.stats == null ? other.stats != null : !this.stats.equals(other.stats)) {
            return false;
        }
        return !(this.instructions == null ? other.instructions != null : !this.instructions.equals(other.instructions));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.importance;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        result = 31 * result + (this.instructions == null ? 0 : this.instructions.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFlowStatsEntryVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.tableId.writeByte(bb);
            bb.writeZero(1);
            bb.writeShort((int)U16.t(message.priority));
            bb.writeShort((int)U16.t(message.idleTimeout));
            bb.writeShort((int)U16.t(message.hardTimeout));
            OFFlowModFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeShort((int)U16.t(message.importance));
            bb.writeLong(message.cookie.getValue());
            message.match.writeTo(bb);
            message.stats.writeTo(bb);
            ChannelUtils.writeList(bb, message.instructions);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowStatsEntryVer15Funnel
    implements Funnel<OFFlowStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFFlowStatsEntryVer15Funnel() {
        }

        public void funnel(OFFlowStatsEntryVer15 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            OFFlowModFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putInt(message.importance);
            message.cookie.putTo(sink);
            message.match.putTo(sink);
            message.stats.putTo(sink);
            FunnelUtils.putList(message.instructions, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowStatsEntry> {
        Reader() {
        }

        @Override
        public OFFlowStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(1);
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            Set<OFFlowModFlags> flags = OFFlowModFlagsSerializerVer15.readFrom(bb);
            int importance = U16.f(bb.readShort());
            U64 cookie = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer15.readOFMatch(bb);
            Stat stats = ChannelUtilsVer15.readOFStat(bb);
            List<OFInstruction> instructions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionVer15.READER);
            OFFlowStatsEntryVer15 flowStatsEntryVer15 = new OFFlowStatsEntryVer15(tableId, priority, idleTimeout, hardTimeout, flags, importance, cookie, match, stats, instructions);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowStatsEntryVer15);
            }
            return flowStatsEntryVer15;
        }
    }

    static class Builder
    implements OFFlowStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean importanceSet;
        private int importance;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowStatsEntry.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public U64 getByteCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.5");
        }

        @Override
        public int getImportance() {
            return this.importance;
        }

        @Override
        public OFFlowStatsEntry.Builder setImportance(int importance) {
            this.importance = importance;
            this.importanceSet = true;
            return this;
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFFlowStatsEntry.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowStatsEntry build() {
            List<OFInstruction> instructions;
            Match match;
            U64 cookie;
            Set<OFFlowModFlags> flags;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            int priority = this.prioritySet ? this.priority : 0;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : 0;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : 0;
            Set<OFFlowModFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int importance = this.importanceSet ? this.importance : 0;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            if (!this.statsSet) {
                throw new IllegalStateException("Property stats doesn't have default value -- must be set");
            }
            if (this.stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            List<OFInstruction> list = instructions = this.instructionsSet ? this.instructions : DEFAULT_INSTRUCTIONS;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFFlowStatsEntryVer15(tableId, priority, idleTimeout, hardTimeout, flags, importance, cookie, match, this.stats, instructions);
        }
    }

    static class BuilderWithParent
    implements OFFlowStatsEntry.Builder {
        final OFFlowStatsEntryVer15 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean importanceSet;
        private int importance;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        BuilderWithParent(OFFlowStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public int getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutSet = true;
            return this;
        }

        @Override
        public int getHardTimeout() {
            return this.hardTimeout;
        }

        @Override
        public OFFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
            this.hardTimeout = hardTimeout;
            this.hardTimeoutSet = true;
            return this;
        }

        @Override
        public Set<OFFlowModFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFFlowStatsEntry.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public U64 getByteCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public List<OFInstruction> getInstructions() {
            return this.instructions;
        }

        @Override
        public OFFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.5");
        }

        @Override
        public OFFlowStatsEntry.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.5");
        }

        @Override
        public int getImportance() {
            return this.importance;
        }

        @Override
        public OFFlowStatsEntry.Builder setImportance(int importance) {
            this.importance = importance;
            this.importanceSet = true;
            return this;
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFFlowStatsEntry.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowStatsEntry build() {
            List instructions;
            Stat stats;
            Match match;
            U64 cookie;
            Set flags;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : this.parentMessage.idleTimeout;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : this.parentMessage.hardTimeout;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int importance = this.importanceSet ? this.importance : this.parentMessage.importance;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            Stat stat = stats = this.statsSet ? this.stats : this.parentMessage.stats;
            if (stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            List list = instructions = this.instructionsSet ? this.instructions : this.parentMessage.instructions;
            if (instructions == null) {
                throw new NullPointerException("Property instructions must not be null");
            }
            return new OFFlowStatsEntryVer15(tableId, priority, idleTimeout, hardTimeout, flags, importance, cookie, match, stats, instructions);
        }
    }
}

