/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerStatusEntry;
import org.projectfloodlight.openflow.protocol.OFControllerStatusStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusEntryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsReplyFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFControllerStatusStatsReplyVer15
implements OFControllerStatusStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFControllerStatusStatsReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFControllerStatusEntry> DEFAULT_CONTROLLER_STATUS = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFControllerStatusEntry> controllerStatus;
    static final OFControllerStatusStatsReplyVer15 DEFAULT = new OFControllerStatusStatsReplyVer15(0L, DEFAULT_FLAGS, DEFAULT_CONTROLLER_STATUS);
    static final Reader READER = new Reader();
    static final OFControllerStatusStatsReplyVer15Funnel FUNNEL = new OFControllerStatusStatsReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFControllerStatusStatsReplyVer15(long xid, Set<OFStatsReplyFlags> flags, List<OFControllerStatusEntry> controllerStatus) {
        if (flags == null) {
            throw new NullPointerException("OFControllerStatusStatsReplyVer15: property flags cannot be null");
        }
        if (controllerStatus == null) {
            throw new NullPointerException("OFControllerStatusStatsReplyVer15: property controllerStatus cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.controllerStatus = controllerStatus;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.CONTROLLER_STATUS;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFControllerStatusEntry> getControllerStatus() {
        return this.controllerStatus;
    }

    @Override
    public OFControllerStatusStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFControllerStatusStatsReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("controllerStatus=").append(this.controllerStatus);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFControllerStatusStatsReplyVer15 other = (OFControllerStatusStatsReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.controllerStatus == null ? other.controllerStatus != null : !this.controllerStatus.equals(other.controllerStatus));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFControllerStatusStatsReplyVer15 other = (OFControllerStatusStatsReplyVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.controllerStatus == null ? other.controllerStatus != null : !this.controllerStatus.equals(other.controllerStatus));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.controllerStatus == null ? 0 : this.controllerStatus.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.controllerStatus == null ? 0 : this.controllerStatus.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFControllerStatusStatsReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFControllerStatusStatsReplyVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(18);
            OFStatsReplyFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.controllerStatus);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFControllerStatusStatsReplyVer15Funnel
    implements Funnel<OFControllerStatusStatsReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFControllerStatusStatsReplyVer15Funnel() {
        }

        public void funnel(OFControllerStatusStatsReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)18);
            OFStatsReplyFlagsSerializerVer15.putTo(message.flags, sink);
            FunnelUtils.putList(message.controllerStatus, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFControllerStatusStatsReply> {
        Reader() {
        }

        @Override
        public OFControllerStatusStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 18) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.CONTROLLER_STATUS(18), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            List<OFControllerStatusEntry> controllerStatus = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFControllerStatusEntryVer15.READER);
            OFControllerStatusStatsReplyVer15 controllerStatusStatsReplyVer15 = new OFControllerStatusStatsReplyVer15(xid, flags, controllerStatus);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)controllerStatusStatsReplyVer15);
            }
            return controllerStatusStatsReplyVer15;
        }
    }

    static class Builder
    implements OFControllerStatusStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean controllerStatusSet;
        private List<OFControllerStatusEntry> controllerStatus;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFControllerStatusStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.CONTROLLER_STATUS;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFControllerStatusStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFControllerStatusEntry> getControllerStatus() {
            return this.controllerStatus;
        }

        @Override
        public OFControllerStatusStatsReply.Builder setControllerStatus(List<OFControllerStatusEntry> controllerStatus) {
            this.controllerStatus = controllerStatus;
            this.controllerStatusSet = true;
            return this;
        }

        @Override
        public OFControllerStatusStatsReply build() {
            List<OFControllerStatusEntry> controllerStatus;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFControllerStatusEntry> list = controllerStatus = this.controllerStatusSet ? this.controllerStatus : DEFAULT_CONTROLLER_STATUS;
            if (controllerStatus == null) {
                throw new NullPointerException("Property controllerStatus must not be null");
            }
            return new OFControllerStatusStatsReplyVer15(xid, flags, controllerStatus);
        }
    }

    static class BuilderWithParent
    implements OFControllerStatusStatsReply.Builder {
        final OFControllerStatusStatsReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean controllerStatusSet;
        private List<OFControllerStatusEntry> controllerStatus;

        BuilderWithParent(OFControllerStatusStatsReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFControllerStatusStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.CONTROLLER_STATUS;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFControllerStatusStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFControllerStatusEntry> getControllerStatus() {
            return this.controllerStatus;
        }

        @Override
        public OFControllerStatusStatsReply.Builder setControllerStatus(List<OFControllerStatusEntry> controllerStatus) {
            this.controllerStatus = controllerStatus;
            this.controllerStatusSet = true;
            return this;
        }

        @Override
        public OFControllerStatusStatsReply build() {
            List controllerStatus;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = controllerStatus = this.controllerStatusSet ? this.controllerStatus : this.parentMessage.controllerStatus;
            if (controllerStatus == null) {
                throw new NullPointerException("Property controllerStatus must not be null");
            }
            return new OFControllerStatusStatsReplyVer15(xid, flags, controllerStatus);
        }
    }
}

