/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundlePropTime;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTime;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFTimeVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundlePropTimeVer15
implements OFBundlePropTime {
    private static final Logger logger = LoggerFactory.getLogger(OFBundlePropTimeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    private static final List<OFTime> DEFAULT_SCHEDULED_TIME = ImmutableList.of();
    private final List<OFTime> scheduledTime;
    static final OFBundlePropTimeVer15 DEFAULT = new OFBundlePropTimeVer15(DEFAULT_SCHEDULED_TIME);
    static final Reader READER = new Reader();
    static final OFBundlePropTimeVer15Funnel FUNNEL = new OFBundlePropTimeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBundlePropTimeVer15(List<OFTime> scheduledTime) {
        if (scheduledTime == null) {
            throw new NullPointerException("OFBundlePropTimeVer15: property scheduledTime cannot be null");
        }
        this.scheduledTime = scheduledTime;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public List<OFTime> getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBundlePropTime.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundlePropTimeVer15(");
        b.append("scheduledTime=").append(this.scheduledTime);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundlePropTimeVer15 other = (OFBundlePropTimeVer15)obj;
        return !(this.scheduledTime == null ? other.scheduledTime != null : !this.scheduledTime.equals(other.scheduledTime));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scheduledTime == null ? 0 : this.scheduledTime.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundlePropTimeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundlePropTimeVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.scheduledTime);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundlePropTimeVer15Funnel
    implements Funnel<OFBundlePropTimeVer15> {
        private static final long serialVersionUID = 1L;

        OFBundlePropTimeVer15Funnel() {
        }

        public void funnel(OFBundlePropTimeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            FunnelUtils.putList(message.scheduledTime, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundlePropTime> {
        Reader() {
        }

        @Override
        public OFBundlePropTime readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            List<OFTime> scheduledTime = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTimeVer15.READER);
            OFBundlePropTimeVer15 bundlePropTimeVer15 = new OFBundlePropTimeVer15(scheduledTime);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundlePropTimeVer15);
            }
            return bundlePropTimeVer15;
        }
    }

    static class Builder
    implements OFBundlePropTime.Builder {
        private boolean scheduledTimeSet;
        private List<OFTime> scheduledTime;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<OFTime> getScheduledTime() {
            return this.scheduledTime;
        }

        @Override
        public OFBundlePropTime.Builder setScheduledTime(List<OFTime> scheduledTime) {
            this.scheduledTime = scheduledTime;
            this.scheduledTimeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBundlePropTime build() {
            List<OFTime> scheduledTime;
            List<OFTime> list = scheduledTime = this.scheduledTimeSet ? this.scheduledTime : DEFAULT_SCHEDULED_TIME;
            if (scheduledTime == null) {
                throw new NullPointerException("Property scheduledTime must not be null");
            }
            return new OFBundlePropTimeVer15(scheduledTime);
        }
    }

    static class BuilderWithParent
    implements OFBundlePropTime.Builder {
        final OFBundlePropTimeVer15 parentMessage;
        private boolean scheduledTimeSet;
        private List<OFTime> scheduledTime;

        BuilderWithParent(OFBundlePropTimeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public List<OFTime> getScheduledTime() {
            return this.scheduledTime;
        }

        @Override
        public OFBundlePropTime.Builder setScheduledTime(List<OFTime> scheduledTime) {
            this.scheduledTime = scheduledTime;
            this.scheduledTimeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBundlePropTime build() {
            List scheduledTime;
            List list = scheduledTime = this.scheduledTimeSet ? this.scheduledTime : this.parentMessage.scheduledTime;
            if (scheduledTime == null) {
                throw new NullPointerException("Property scheduledTime must not be null");
            }
            return new OFBundlePropTimeVer15(scheduledTime);
        }
    }
}

