/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvOuterSrcMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvOuterSrcMacVer15
implements OFBsnTlvOuterSrcMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvOuterSrcMacVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvOuterSrcMacVer15 DEFAULT = new OFBsnTlvOuterSrcMacVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvOuterSrcMacVer15Funnel FUNNEL = new OFBsnTlvOuterSrcMacVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvOuterSrcMacVer15(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvOuterSrcMacVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 157;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvOuterSrcMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvOuterSrcMacVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvOuterSrcMacVer15 other = (OFBsnTlvOuterSrcMacVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvOuterSrcMacVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvOuterSrcMacVer15 message) {
            bb.writeShort(157);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvOuterSrcMacVer15Funnel
    implements Funnel<OFBsnTlvOuterSrcMacVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvOuterSrcMacVer15Funnel() {
        }

        public void funnel(OFBsnTlvOuterSrcMacVer15 message, PrimitiveSink sink) {
            sink.putShort((short)157);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvOuterSrcMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvOuterSrcMac readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 157) {
                throw new OFParseError("Wrong type: Expected=0x9d(0x9d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvOuterSrcMacVer15 bsnTlvOuterSrcMacVer15 = new OFBsnTlvOuterSrcMacVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvOuterSrcMacVer15);
            }
            return bsnTlvOuterSrcMacVer15;
        }
    }

    static class Builder
    implements OFBsnTlvOuterSrcMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 157;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvOuterSrcMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvOuterSrcMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvOuterSrcMacVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvOuterSrcMac.Builder {
        final OFBsnTlvOuterSrcMacVer15 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvOuterSrcMacVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 157;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvOuterSrcMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvOuterSrcMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvOuterSrcMacVer15(value);
        }
    }
}

