/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashPacketType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashPacketType;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnHashPacketTypeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashPacketTypeVer15
implements OFBsnTlvHashPacketType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashPacketTypeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final OFBsnHashPacketType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvHashPacketTypeVer15Funnel FUNNEL = new OFBsnTlvHashPacketTypeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashPacketTypeVer15(OFBsnHashPacketType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashPacketTypeVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public OFBsnHashPacketType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvHashPacketType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashPacketTypeVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashPacketTypeVer15 other = (OFBsnTlvHashPacketTypeVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashPacketTypeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashPacketTypeVer15 message) {
            bb.writeShort(102);
            bb.writeShort(5);
            OFBsnHashPacketTypeSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashPacketTypeVer15Funnel
    implements Funnel<OFBsnTlvHashPacketTypeVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashPacketTypeVer15Funnel() {
        }

        public void funnel(OFBsnTlvHashPacketTypeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)102);
            sink.putShort((short)5);
            OFBsnHashPacketTypeSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashPacketType> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashPacketType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 102) {
                throw new OFParseError("Wrong type: Expected=0x66(0x66), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnHashPacketType value = OFBsnHashPacketTypeSerializerVer15.readFrom(bb);
            OFBsnTlvHashPacketTypeVer15 bsnTlvHashPacketTypeVer15 = new OFBsnTlvHashPacketTypeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashPacketTypeVer15);
            }
            return bsnTlvHashPacketTypeVer15;
        }
    }

    static class Builder
    implements OFBsnTlvHashPacketType.Builder {
        private boolean valueSet;
        private OFBsnHashPacketType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 102;
        }

        @Override
        public OFBsnHashPacketType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketType.Builder setValue(OFBsnHashPacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashPacketType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketTypeVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashPacketType.Builder {
        final OFBsnTlvHashPacketTypeVer15 parentMessage;
        private boolean valueSet;
        private OFBsnHashPacketType value;

        BuilderWithParent(OFBsnTlvHashPacketTypeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 102;
        }

        @Override
        public OFBsnHashPacketType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketType.Builder setValue(OFBsnHashPacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashPacketType build() {
            OFBsnHashPacketType value;
            OFBsnHashPacketType oFBsnHashPacketType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketTypeVer15(value);
        }
    }
}

