/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLacpState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActorState;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLacpStateSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActorStateVer15
implements OFBsnTlvActorState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActorStateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final Set<OFBsnLacpState> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnLacpState> value;
    static final OFBsnTlvActorStateVer15 DEFAULT = new OFBsnTlvActorStateVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvActorStateVer15Funnel FUNNEL = new OFBsnTlvActorStateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActorStateVer15(Set<OFBsnLacpState> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvActorStateVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 53;
    }

    @Override
    public Set<OFBsnLacpState> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvActorState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActorStateVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActorStateVer15 other = (OFBsnTlvActorStateVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActorStateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvActorStateVer15 message) {
            bb.writeShort(53);
            bb.writeShort(5);
            OFBsnLacpStateSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvActorStateVer15Funnel
    implements Funnel<OFBsnTlvActorStateVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActorStateVer15Funnel() {
        }

        public void funnel(OFBsnTlvActorStateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)53);
            sink.putShort((short)5);
            OFBsnLacpStateSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActorState> {
        Reader() {
        }

        @Override
        public OFBsnTlvActorState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 53) {
                throw new OFParseError("Wrong type: Expected=0x35(0x35), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnLacpState> value = OFBsnLacpStateSerializerVer15.readFrom(bb);
            OFBsnTlvActorStateVer15 bsnTlvActorStateVer15 = new OFBsnTlvActorStateVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActorStateVer15);
            }
            return bsnTlvActorStateVer15;
        }
    }

    static class Builder
    implements OFBsnTlvActorState.Builder {
        private boolean valueSet;
        private Set<OFBsnLacpState> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 53;
        }

        @Override
        public Set<OFBsnLacpState> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorState.Builder setValue(Set<OFBsnLacpState> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvActorState build() {
            Set<OFBsnLacpState> value;
            Set<OFBsnLacpState> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActorStateVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActorState.Builder {
        final OFBsnTlvActorStateVer15 parentMessage;
        private boolean valueSet;
        private Set<OFBsnLacpState> value;

        BuilderWithParent(OFBsnTlvActorStateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 53;
        }

        @Override
        public Set<OFBsnLacpState> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorState.Builder setValue(Set<OFBsnLacpState> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvActorState build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvActorStateVer15(value);
        }
    }
}

