/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowIdleEnableGetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowIdleEnableGetRequestVer15
implements OFBsnFlowIdleEnableGetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowIdleEnableGetRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnFlowIdleEnableGetRequestVer15 DEFAULT = new OFBsnFlowIdleEnableGetRequestVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnFlowIdleEnableGetRequestVer15Funnel FUNNEL = new OFBsnFlowIdleEnableGetRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowIdleEnableGetRequestVer15(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 38L;
    }

    @Override
    public OFBsnFlowIdleEnableGetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowIdleEnableGetRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleEnableGetRequestVer15 other = (OFBsnFlowIdleEnableGetRequestVer15)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleEnableGetRequestVer15 other = (OFBsnFlowIdleEnableGetRequestVer15)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowIdleEnableGetRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnFlowIdleEnableGetRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(38);
        }
    }

    static class OFBsnFlowIdleEnableGetRequestVer15Funnel
    implements Funnel<OFBsnFlowIdleEnableGetRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowIdleEnableGetRequestVer15Funnel() {
        }

        public void funnel(OFBsnFlowIdleEnableGetRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(38);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowIdleEnableGetRequest> {
        Reader() {
        }

        @Override
        public OFBsnFlowIdleEnableGetRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 38) {
                throw new OFParseError("Wrong subtype: Expected=0x26L(0x26L), got=" + subtype);
            }
            OFBsnFlowIdleEnableGetRequestVer15 bsnFlowIdleEnableGetRequestVer15 = new OFBsnFlowIdleEnableGetRequestVer15(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowIdleEnableGetRequestVer15);
            }
            return bsnFlowIdleEnableGetRequestVer15;
        }
    }

    static class Builder
    implements OFBsnFlowIdleEnableGetRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 38L;
        }

        @Override
        public OFBsnFlowIdleEnableGetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnFlowIdleEnableGetRequestVer15(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowIdleEnableGetRequest.Builder {
        final OFBsnFlowIdleEnableGetRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnFlowIdleEnableGetRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdleEnableGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 38L;
        }

        @Override
        public OFBsnFlowIdleEnableGetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnFlowIdleEnableGetRequestVer15(xid);
        }
    }
}

