/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnDebugCounterDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnDebugCounterDescStatsRequestVer15
implements OFBsnDebugCounterDescStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnDebugCounterDescStatsRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    static final OFBsnDebugCounterDescStatsRequestVer15 DEFAULT = new OFBsnDebugCounterDescStatsRequestVer15(0L, DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFBsnDebugCounterDescStatsRequestVer15Funnel FUNNEL = new OFBsnDebugCounterDescStatsRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnDebugCounterDescStatsRequestVer15(long xid, Set<OFStatsRequestFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFBsnDebugCounterDescStatsRequestVer15: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 13L;
    }

    @Override
    public OFBsnDebugCounterDescStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnDebugCounterDescStatsRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnDebugCounterDescStatsRequestVer15 other = (OFBsnDebugCounterDescStatsRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnDebugCounterDescStatsRequestVer15 other = (OFBsnDebugCounterDescStatsRequestVer15)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnDebugCounterDescStatsRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnDebugCounterDescStatsRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(13);
        }
    }

    static class OFBsnDebugCounterDescStatsRequestVer15Funnel
    implements Funnel<OFBsnDebugCounterDescStatsRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnDebugCounterDescStatsRequestVer15Funnel() {
        }

        public void funnel(OFBsnDebugCounterDescStatsRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(13);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnDebugCounterDescStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 13) {
                throw new OFParseError("Wrong subtype: Expected=0xdL(0xdL), got=" + subtype);
            }
            OFBsnDebugCounterDescStatsRequestVer15 bsnDebugCounterDescStatsRequestVer15 = new OFBsnDebugCounterDescStatsRequestVer15(xid, flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnDebugCounterDescStatsRequestVer15);
            }
            return bsnDebugCounterDescStatsRequestVer15;
        }
    }

    static class Builder
    implements OFBsnDebugCounterDescStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 13L;
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnDebugCounterDescStatsRequestVer15(xid, flags);
        }
    }

    static class BuilderWithParent
    implements OFBsnDebugCounterDescStatsRequest.Builder {
        final OFBsnDebugCounterDescStatsRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        BuilderWithParent(OFBsnDebugCounterDescStatsRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 13L;
        }

        @Override
        public OFBsnDebugCounterDescStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnDebugCounterDescStatsRequestVer15(xid, flags);
        }
    }
}

