/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBarrierRequestVer15
implements OFBarrierRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBarrierRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBarrierRequestVer15 DEFAULT = new OFBarrierRequestVer15(0L);
    static final Reader READER = new Reader();
    static final OFBarrierRequestVer15Funnel FUNNEL = new OFBarrierRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBarrierRequestVer15(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.BARRIER_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBarrierRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBarrierRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBarrierRequestVer15 other = (OFBarrierRequestVer15)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBarrierRequestVer15 other = (OFBarrierRequestVer15)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBarrierRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBarrierRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(20);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFBarrierRequestVer15Funnel
    implements Funnel<OFBarrierRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBarrierRequestVer15Funnel() {
        }

        public void funnel(OFBarrierRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)20);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFBarrierRequest> {
        Reader() {
        }

        @Override
        public OFBarrierRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 20) {
                throw new OFParseError("Wrong type: Expected=OFType.BARRIER_REQUEST(20), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBarrierRequestVer15 barrierRequestVer15 = new OFBarrierRequestVer15(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)barrierRequestVer15);
            }
            return barrierRequestVer15;
        }
    }

    static class Builder
    implements OFBarrierRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.BARRIER_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBarrierRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBarrierRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBarrierRequestVer15(xid);
        }
    }

    static class BuilderWithParent
    implements OFBarrierRequest.Builder {
        final OFBarrierRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBarrierRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.BARRIER_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBarrierRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBarrierRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBarrierRequestVer15(xid);
        }
    }
}

