/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropRoleStatusSlave;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropRoleStatusSlaveVer15
implements OFAsyncConfigPropRoleStatusSlave {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropRoleStatusSlaveVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropRoleStatusSlaveVer15 DEFAULT = new OFAsyncConfigPropRoleStatusSlaveVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropRoleStatusSlaveVer15Funnel FUNNEL = new OFAsyncConfigPropRoleStatusSlaveVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropRoleStatusSlaveVer15(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropRoleStatusSlave.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropRoleStatusSlaveVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropRoleStatusSlaveVer15 other = (OFAsyncConfigPropRoleStatusSlaveVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropRoleStatusSlaveVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropRoleStatusSlaveVer15 message) {
            bb.writeShort(6);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropRoleStatusSlaveVer15Funnel
    implements Funnel<OFAsyncConfigPropRoleStatusSlaveVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropRoleStatusSlaveVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropRoleStatusSlaveVer15 message, PrimitiveSink sink) {
            sink.putShort((short)6);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropRoleStatusSlave> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropRoleStatusSlave readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=0x6(0x6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropRoleStatusSlaveVer15 asyncConfigPropRoleStatusSlaveVer15 = new OFAsyncConfigPropRoleStatusSlaveVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropRoleStatusSlaveVer15);
            }
            return asyncConfigPropRoleStatusSlaveVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropRoleStatusSlave.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRoleStatusSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropRoleStatusSlave build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropRoleStatusSlaveVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropRoleStatusSlave.Builder {
        final OFAsyncConfigPropRoleStatusSlaveVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropRoleStatusSlaveVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRoleStatusSlave.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropRoleStatusSlave build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropRoleStatusSlaveVer15(mask);
        }
    }
}

