/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAggregateStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.ChannelUtilsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsReplyFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAggregateStatsReplyVer15
implements OFAggregateStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFAggregateStatsReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final Stat stats;
    static final Reader READER = new Reader();
    static final OFAggregateStatsReplyVer15Funnel FUNNEL = new OFAggregateStatsReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAggregateStatsReplyVer15(long xid, Set<OFStatsReplyFlags> flags, Stat stats) {
        if (flags == null) {
            throw new NullPointerException("OFAggregateStatsReplyVer15: property flags cannot be null");
        }
        if (stats == null) {
            throw new NullPointerException("OFAggregateStatsReplyVer15: property stats cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.stats = stats;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.AGGREGATE;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public U64 getPacketCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public U64 getByteCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public long getFlowCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property flowCount not supported in version 1.5");
    }

    @Override
    public Stat getStats() {
        return this.stats;
    }

    @Override
    public OFAggregateStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAggregateStatsReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("stats=").append(this.stats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAggregateStatsReplyVer15 other = (OFAggregateStatsReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAggregateStatsReplyVer15 other = (OFAggregateStatsReplyVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAggregateStatsReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAggregateStatsReplyVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(19);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(2);
            OFStatsReplyFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            message.stats.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFAggregateStatsReplyVer15Funnel
    implements Funnel<OFAggregateStatsReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFAggregateStatsReplyVer15Funnel() {
        }

        public void funnel(OFAggregateStatsReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)19);
            sink.putLong(message.xid);
            sink.putShort((short)2);
            OFStatsReplyFlagsSerializerVer15.putTo(message.flags, sink);
            message.stats.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFAggregateStatsReply> {
        Reader() {
        }

        @Override
        public OFAggregateStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 2) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.AGGREGATE(2), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            Stat stats = ChannelUtilsVer15.readOFStat(bb);
            OFAggregateStatsReplyVer15 aggregateStatsReplyVer15 = new OFAggregateStatsReplyVer15(xid, flags, stats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)aggregateStatsReplyVer15);
            }
            return aggregateStatsReplyVer15;
        }
    }

    static class Builder
    implements OFAggregateStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean statsSet;
        private Stat stats;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAggregateStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.AGGREGATE;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFAggregateStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public OFAggregateStatsReply.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public U64 getByteCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public OFAggregateStatsReply.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public long getFlowCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowCount not supported in version 1.5");
        }

        @Override
        public OFAggregateStatsReply.Builder setFlowCount(long flowCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowCount not supported in version 1.5");
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFAggregateStatsReply.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFAggregateStatsReply build() {
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            if (!this.statsSet) {
                throw new IllegalStateException("Property stats doesn't have default value -- must be set");
            }
            if (this.stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFAggregateStatsReplyVer15(xid, flags, this.stats);
        }
    }

    static class BuilderWithParent
    implements OFAggregateStatsReply.Builder {
        final OFAggregateStatsReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean statsSet;
        private Stat stats;

        BuilderWithParent(OFAggregateStatsReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAggregateStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.AGGREGATE;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFAggregateStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public OFAggregateStatsReply.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
        }

        @Override
        public U64 getByteCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public OFAggregateStatsReply.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
        }

        @Override
        public long getFlowCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowCount not supported in version 1.5");
        }

        @Override
        public OFAggregateStatsReply.Builder setFlowCount(long flowCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property flowCount not supported in version 1.5");
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFAggregateStatsReply.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFAggregateStatsReply build() {
            Stat stats;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Stat stat = stats = this.statsSet ? this.stats : this.parentMessage.stats;
            if (stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFAggregateStatsReplyVer15(xid, flags, stats);
        }
    }
}

