/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwTtl;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetNwTtlVer15
implements OFActionSetNwTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetNwTtlVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final short DEFAULT_NW_TTL = 0;
    private final short nwTtl;
    static final OFActionSetNwTtlVer15 DEFAULT = new OFActionSetNwTtlVer15(0);
    static final Reader READER = new Reader();
    static final OFActionSetNwTtlVer15Funnel FUNNEL = new OFActionSetNwTtlVer15Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetNwTtlVer15(short nwTtl) {
        this.nwTtl = nwTtl;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_NW_TTL;
    }

    @Override
    public short getNwTtl() {
        return this.nwTtl;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionSetNwTtl.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetNwTtlVer15(");
        b.append("nwTtl=").append(this.nwTtl);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetNwTtlVer15 other = (OFActionSetNwTtlVer15)obj;
        return this.nwTtl == other.nwTtl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nwTtl;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetNwTtlVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetNwTtlVer15 message) {
            bb.writeShort(23);
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.nwTtl));
            bb.writeZero(3);
        }
    }

    static class OFActionSetNwTtlVer15Funnel
    implements Funnel<OFActionSetNwTtlVer15> {
        private static final long serialVersionUID = 1L;

        OFActionSetNwTtlVer15Funnel() {
        }

        public void funnel(OFActionSetNwTtlVer15 message, PrimitiveSink sink) {
            sink.putShort((short)23);
            sink.putShort((short)8);
            sink.putShort(message.nwTtl);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetNwTtl> {
        Reader() {
        }

        @Override
        public OFActionSetNwTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 23) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_NW_TTL(23), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short nwTtl = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionSetNwTtlVer15 actionSetNwTtlVer15 = new OFActionSetNwTtlVer15(nwTtl);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetNwTtlVer15);
            }
            return actionSetNwTtlVer15;
        }
    }

    static class Builder
    implements OFActionSetNwTtl.Builder {
        private boolean nwTtlSet;
        private short nwTtl;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_TTL;
        }

        @Override
        public short getNwTtl() {
            return this.nwTtl;
        }

        @Override
        public OFActionSetNwTtl.Builder setNwTtl(short nwTtl) {
            this.nwTtl = nwTtl;
            this.nwTtlSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionSetNwTtl build() {
            short nwTtl = this.nwTtlSet ? this.nwTtl : (short)0;
            return new OFActionSetNwTtlVer15(nwTtl);
        }
    }

    static class BuilderWithParent
    implements OFActionSetNwTtl.Builder {
        final OFActionSetNwTtlVer15 parentMessage;
        private boolean nwTtlSet;
        private short nwTtl;

        BuilderWithParent(OFActionSetNwTtlVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_TTL;
        }

        @Override
        public short getNwTtl() {
            return this.nwTtl;
        }

        @Override
        public OFActionSetNwTtl.Builder setNwTtl(short nwTtl) {
            this.nwTtl = nwTtl;
            this.nwTtlSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionSetNwTtl build() {
            short nwTtl = this.nwTtlSet ? this.nwTtl : this.parentMessage.nwTtl;
            return new OFActionSetNwTtlVer15(nwTtl);
        }
    }
}

