/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsRequestFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterStatsRequestVer14
implements OFMeterStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterStatsRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_METER_ID = 0L;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final long meterId;
    static final OFMeterStatsRequestVer14 DEFAULT = new OFMeterStatsRequestVer14(0L, DEFAULT_FLAGS, 0L);
    static final Reader READER = new Reader();
    static final OFMeterStatsRequestVer14Funnel FUNNEL = new OFMeterStatsRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterStatsRequestVer14(long xid, Set<OFStatsRequestFlags> flags, long meterId) {
        if (flags == null) {
            throw new NullPointerException("OFMeterStatsRequestVer14: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.meterId = meterId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.METER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public OFMeterStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterStatsRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("meterId=").append(this.meterId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterStatsRequestVer14 other = (OFMeterStatsRequestVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.meterId == other.meterId;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterStatsRequestVer14 other = (OFMeterStatsRequestVer14)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.meterId == other.meterId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterStatsRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterStatsRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(18);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(9);
            OFStatsRequestFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(U32.t(message.meterId));
            bb.writeZero(4);
        }
    }

    static class OFMeterStatsRequestVer14Funnel
    implements Funnel<OFMeterStatsRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterStatsRequestVer14Funnel() {
        }

        public void funnel(OFMeterStatsRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)18);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putShort((short)9);
            OFStatsRequestFlagsSerializerVer14.putTo(message.flags, sink);
            sink.putLong(message.meterId);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterStatsRequest> {
        Reader() {
        }

        @Override
        public OFMeterStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 9) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.METER(9), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            long meterId = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFMeterStatsRequestVer14 meterStatsRequestVer14 = new OFMeterStatsRequestVer14(xid, flags, meterId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterStatsRequestVer14);
            }
            return meterStatsRequestVer14;
        }
    }

    static class Builder
    implements OFMeterStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean meterIdSet;
        private long meterId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.METER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterStatsRequest.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFMeterStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : 0L;
            return new OFMeterStatsRequestVer14(xid, flags, meterId);
        }
    }

    static class BuilderWithParent
    implements OFMeterStatsRequest.Builder {
        final OFMeterStatsRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean meterIdSet;
        private long meterId;

        BuilderWithParent(OFMeterStatsRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.METER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterStatsRequest.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFMeterStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            return new OFMeterStatsRequestVer14(xid, flags, meterId);
        }
    }
}

