/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUnknownMulticastRate;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUnknownMulticastRateVer14
implements OFBsnTlvUnknownMulticastRate {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUnknownMulticastRateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvUnknownMulticastRateVer14 DEFAULT = new OFBsnTlvUnknownMulticastRateVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvUnknownMulticastRateVer14Funnel FUNNEL = new OFBsnTlvUnknownMulticastRateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUnknownMulticastRateVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 92;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvUnknownMulticastRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUnknownMulticastRateVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUnknownMulticastRateVer14 other = (OFBsnTlvUnknownMulticastRateVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUnknownMulticastRateVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUnknownMulticastRateVer14 message) {
            bb.writeShort(92);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvUnknownMulticastRateVer14Funnel
    implements Funnel<OFBsnTlvUnknownMulticastRateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUnknownMulticastRateVer14Funnel() {
        }

        public void funnel(OFBsnTlvUnknownMulticastRateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)92);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUnknownMulticastRate> {
        Reader() {
        }

        @Override
        public OFBsnTlvUnknownMulticastRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 92) {
                throw new OFParseError("Wrong type: Expected=0x5c(0x5c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvUnknownMulticastRateVer14 bsnTlvUnknownMulticastRateVer14 = new OFBsnTlvUnknownMulticastRateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUnknownMulticastRateVer14);
            }
            return bsnTlvUnknownMulticastRateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvUnknownMulticastRate.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 92;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUnknownMulticastRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUnknownMulticastRate build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvUnknownMulticastRateVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUnknownMulticastRate.Builder {
        final OFBsnTlvUnknownMulticastRateVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvUnknownMulticastRateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 92;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUnknownMulticastRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUnknownMulticastRate build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUnknownMulticastRateVer14(value);
        }
    }
}

