/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnRoutingParam;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRoutingParam;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnRoutingParamSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRoutingParamVer14
implements OFBsnTlvRoutingParam {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRoutingParamVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private final OFBsnRoutingParam value;
    static final Reader READER = new Reader();
    static final OFBsnTlvRoutingParamVer14Funnel FUNNEL = new OFBsnTlvRoutingParamVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRoutingParamVer14(OFBsnRoutingParam value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRoutingParamVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 161;
    }

    @Override
    public OFBsnRoutingParam getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvRoutingParam.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRoutingParamVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRoutingParamVer14 other = (OFBsnTlvRoutingParamVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRoutingParamVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRoutingParamVer14 message) {
            bb.writeShort(161);
            bb.writeShort(6);
            OFBsnRoutingParamSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvRoutingParamVer14Funnel
    implements Funnel<OFBsnTlvRoutingParamVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRoutingParamVer14Funnel() {
        }

        public void funnel(OFBsnTlvRoutingParamVer14 message, PrimitiveSink sink) {
            sink.putShort((short)161);
            sink.putShort((short)6);
            OFBsnRoutingParamSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRoutingParam> {
        Reader() {
        }

        @Override
        public OFBsnTlvRoutingParam readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 161) {
                throw new OFParseError("Wrong type: Expected=0xa1(0xa1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnRoutingParam value = OFBsnRoutingParamSerializerVer14.readFrom(bb);
            OFBsnTlvRoutingParamVer14 bsnTlvRoutingParamVer14 = new OFBsnTlvRoutingParamVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRoutingParamVer14);
            }
            return bsnTlvRoutingParamVer14;
        }
    }

    static class Builder
    implements OFBsnTlvRoutingParam.Builder {
        private boolean valueSet;
        private OFBsnRoutingParam value;

        Builder() {
        }

        @Override
        public int getType() {
            return 161;
        }

        @Override
        public OFBsnRoutingParam getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRoutingParam.Builder setValue(OFBsnRoutingParam value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRoutingParam build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRoutingParamVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRoutingParam.Builder {
        final OFBsnTlvRoutingParamVer14 parentMessage;
        private boolean valueSet;
        private OFBsnRoutingParam value;

        BuilderWithParent(OFBsnTlvRoutingParamVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 161;
        }

        @Override
        public OFBsnRoutingParam getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRoutingParam.Builder setValue(OFBsnRoutingParam value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRoutingParam build() {
            OFBsnRoutingParam value;
            OFBsnRoutingParam oFBsnRoutingParam = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRoutingParamVer14(value);
        }
    }
}

