/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortMode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPortMode;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPortModeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortModeVer14
implements OFBsnTlvPortMode {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortModeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private final OFBsnPortMode value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPortModeVer14Funnel FUNNEL = new OFBsnTlvPortModeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortModeVer14(OFBsnPortMode value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPortModeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 179;
    }

    @Override
    public OFBsnPortMode getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvPortMode.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortModeVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortModeVer14 other = (OFBsnTlvPortModeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortModeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPortModeVer14 message) {
            bb.writeShort(179);
            bb.writeShort(6);
            OFBsnPortModeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPortModeVer14Funnel
    implements Funnel<OFBsnTlvPortModeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortModeVer14Funnel() {
        }

        public void funnel(OFBsnTlvPortModeVer14 message, PrimitiveSink sink) {
            sink.putShort((short)179);
            sink.putShort((short)6);
            OFBsnPortModeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPortMode> {
        Reader() {
        }

        @Override
        public OFBsnTlvPortMode readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 179) {
                throw new OFParseError("Wrong type: Expected=0xb3(0xb3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPortMode value = OFBsnPortModeSerializerVer14.readFrom(bb);
            OFBsnTlvPortModeVer14 bsnTlvPortModeVer14 = new OFBsnTlvPortModeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortModeVer14);
            }
            return bsnTlvPortModeVer14;
        }
    }

    static class Builder
    implements OFBsnTlvPortMode.Builder {
        private boolean valueSet;
        private OFBsnPortMode value;

        Builder() {
        }

        @Override
        public int getType() {
            return 179;
        }

        @Override
        public OFBsnPortMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortMode.Builder setValue(OFBsnPortMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPortMode build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortModeVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPortMode.Builder {
        final OFBsnTlvPortModeVer14 parentMessage;
        private boolean valueSet;
        private OFBsnPortMode value;

        BuilderWithParent(OFBsnTlvPortModeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 179;
        }

        @Override
        public OFBsnPortMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortMode.Builder setValue(OFBsnPortMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPortMode build() {
            OFBsnPortMode value;
            OFBsnPortMode oFBsnPortMode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortModeVer14(value);
        }
    }
}

