/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvNextHopMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvNextHopMacVer14
implements OFBsnTlvNextHopMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvNextHopMacVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvNextHopMacVer14 DEFAULT = new OFBsnTlvNextHopMacVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvNextHopMacVer14Funnel FUNNEL = new OFBsnTlvNextHopMacVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvNextHopMacVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvNextHopMacVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 114;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvNextHopMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvNextHopMacVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvNextHopMacVer14 other = (OFBsnTlvNextHopMacVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvNextHopMacVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvNextHopMacVer14 message) {
            bb.writeShort(114);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvNextHopMacVer14Funnel
    implements Funnel<OFBsnTlvNextHopMacVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvNextHopMacVer14Funnel() {
        }

        public void funnel(OFBsnTlvNextHopMacVer14 message, PrimitiveSink sink) {
            sink.putShort((short)114);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvNextHopMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvNextHopMac readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 114) {
                throw new OFParseError("Wrong type: Expected=0x72(0x72), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvNextHopMacVer14 bsnTlvNextHopMacVer14 = new OFBsnTlvNextHopMacVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvNextHopMacVer14);
            }
            return bsnTlvNextHopMacVer14;
        }
    }

    static class Builder
    implements OFBsnTlvNextHopMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 114;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvNextHopMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvNextHopMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvNextHopMacVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvNextHopMac.Builder {
        final OFBsnTlvNextHopMacVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvNextHopMacVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 114;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvNextHopMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvNextHopMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvNextHopMacVer14(value);
        }
    }
}

