/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBucket;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTlvVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBucketVer14
implements OFBsnTlvBucket {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBucketVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFBsnTlv> DEFAULT_VALUE = ImmutableList.of();
    private final List<OFBsnTlv> value;
    static final OFBsnTlvBucketVer14 DEFAULT = new OFBsnTlvBucketVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvBucketVer14Funnel FUNNEL = new OFBsnTlvBucketVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBucketVer14(List<OFBsnTlv> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBucketVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public List<OFBsnTlv> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvBucket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBucketVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBucketVer14 other = (OFBsnTlvBucketVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBucketVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBucketVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(64);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvBucketVer14Funnel
    implements Funnel<OFBsnTlvBucketVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBucketVer14Funnel() {
        }

        public void funnel(OFBsnTlvBucketVer14 message, PrimitiveSink sink) {
            sink.putShort((short)64);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBucket> {
        Reader() {
        }

        @Override
        public OFBsnTlvBucket readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 64) {
                throw new OFParseError("Wrong type: Expected=0x40(0x40), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFBsnTlv> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer14.READER);
            OFBsnTlvBucketVer14 bsnTlvBucketVer14 = new OFBsnTlvBucketVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBucketVer14);
            }
            return bsnTlvBucketVer14;
        }
    }

    static class Builder
    implements OFBsnTlvBucket.Builder {
        private boolean valueSet;
        private List<OFBsnTlv> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 64;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBucket.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBucket build() {
            List<OFBsnTlv> value;
            List<OFBsnTlv> list = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBucketVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBucket.Builder {
        final OFBsnTlvBucketVer14 parentMessage;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        BuilderWithParent(OFBsnTlvBucketVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 64;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBucket.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBucket build() {
            List value;
            List list = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBucketVer14(value);
        }
    }
}

