/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetMirroring;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetMirroringVer14
implements OFBsnSetMirroring {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetMirroringVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_REPORT_MIRROR_PORTS = 0;
    private final long xid;
    private final short reportMirrorPorts;
    static final OFBsnSetMirroringVer14 DEFAULT = new OFBsnSetMirroringVer14(0L, 0);
    static final Reader READER = new Reader();
    static final OFBsnSetMirroringVer14Funnel FUNNEL = new OFBsnSetMirroringVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetMirroringVer14(long xid, short reportMirrorPorts) {
        this.xid = xid;
        this.reportMirrorPorts = reportMirrorPorts;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 3L;
    }

    @Override
    public short getReportMirrorPorts() {
        return this.reportMirrorPorts;
    }

    @Override
    public OFBsnSetMirroring.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetMirroringVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reportMirrorPorts=").append(this.reportMirrorPorts);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetMirroringVer14 other = (OFBsnSetMirroringVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.reportMirrorPorts == other.reportMirrorPorts;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetMirroringVer14 other = (OFBsnSetMirroringVer14)obj;
        return this.reportMirrorPorts == other.reportMirrorPorts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.reportMirrorPorts;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.reportMirrorPorts;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetMirroringVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetMirroringVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(3);
            bb.writeByte((int)U8.t(message.reportMirrorPorts));
            bb.writeZero(3);
        }
    }

    static class OFBsnSetMirroringVer14Funnel
    implements Funnel<OFBsnSetMirroringVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnSetMirroringVer14Funnel() {
        }

        public void funnel(OFBsnSetMirroringVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(3);
            sink.putShort(message.reportMirrorPorts);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetMirroring> {
        Reader() {
        }

        @Override
        public OFBsnSetMirroring readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 3) {
                throw new OFParseError("Wrong subtype: Expected=0x3L(0x3L), got=" + subtype);
            }
            short reportMirrorPorts = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFBsnSetMirroringVer14 bsnSetMirroringVer14 = new OFBsnSetMirroringVer14(xid, reportMirrorPorts);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetMirroringVer14);
            }
            return bsnSetMirroringVer14;
        }
    }

    static class Builder
    implements OFBsnSetMirroring.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reportMirrorPortsSet;
        private short reportMirrorPorts;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetMirroring.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 3L;
        }

        @Override
        public short getReportMirrorPorts() {
            return this.reportMirrorPorts;
        }

        @Override
        public OFBsnSetMirroring.Builder setReportMirrorPorts(short reportMirrorPorts) {
            this.reportMirrorPorts = reportMirrorPorts;
            this.reportMirrorPortsSet = true;
            return this;
        }

        @Override
        public OFBsnSetMirroring build() {
            long xid = this.xidSet ? this.xid : 0L;
            short reportMirrorPorts = this.reportMirrorPortsSet ? this.reportMirrorPorts : (short)0;
            return new OFBsnSetMirroringVer14(xid, reportMirrorPorts);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetMirroring.Builder {
        final OFBsnSetMirroringVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reportMirrorPortsSet;
        private short reportMirrorPorts;

        BuilderWithParent(OFBsnSetMirroringVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetMirroring.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 3L;
        }

        @Override
        public short getReportMirrorPorts() {
            return this.reportMirrorPorts;
        }

        @Override
        public OFBsnSetMirroring.Builder setReportMirrorPorts(short reportMirrorPorts) {
            this.reportMirrorPorts = reportMirrorPorts;
            this.reportMirrorPortsSet = true;
            return this;
        }

        @Override
        public OFBsnSetMirroring build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short reportMirrorPorts = this.reportMirrorPortsSet ? this.reportMirrorPorts : this.parentMessage.reportMirrorPorts;
            return new OFBsnSetMirroringVer14(xid, reportMirrorPorts);
        }
    }
}

