/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTlvVer14;
import org.projectfloodlight.openflow.types.U128;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableEntryDescStatsEntryVer14
implements OFBsnGentableEntryDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableEntryDescStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 20;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private static final List<OFBsnTlv> DEFAULT_KEY = ImmutableList.of();
    private static final List<OFBsnTlv> DEFAULT_VALUE = ImmutableList.of();
    private final U128 checksum;
    private final List<OFBsnTlv> key;
    private final List<OFBsnTlv> value;
    static final OFBsnGentableEntryDescStatsEntryVer14 DEFAULT = new OFBsnGentableEntryDescStatsEntryVer14(DEFAULT_CHECKSUM, DEFAULT_KEY, DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnGentableEntryDescStatsEntryVer14Funnel FUNNEL = new OFBsnGentableEntryDescStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableEntryDescStatsEntryVer14(U128 checksum, List<OFBsnTlv> key, List<OFBsnTlv> value) {
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsEntryVer14: property checksum cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsEntryVer14: property key cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsEntryVer14: property value cannot be null");
        }
        this.checksum = checksum;
        this.key = key;
        this.value = value;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public List<OFBsnTlv> getKey() {
        return this.key;
    }

    @Override
    public List<OFBsnTlv> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnGentableEntryDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableEntryDescStatsEntryVer14(");
        b.append("checksum=").append(this.checksum);
        b.append(", ");
        b.append("key=").append(this.key);
        b.append(", ");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableEntryDescStatsEntryVer14 other = (OFBsnGentableEntryDescStatsEntryVer14)obj;
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableEntryDescStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableEntryDescStatsEntryVer14 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            int keyLengthIndex = bb.writerIndex();
            bb.writeShort(0);
            message.checksum.write16Bytes(bb);
            int keyStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.key);
            int keyLength = bb.writerIndex() - keyStartIndex;
            bb.setShort(keyLengthIndex, keyLength);
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGentableEntryDescStatsEntryVer14Funnel
    implements Funnel<OFBsnGentableEntryDescStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableEntryDescStatsEntryVer14Funnel() {
        }

        public void funnel(OFBsnGentableEntryDescStatsEntryVer14 message, PrimitiveSink sink) {
            message.checksum.putTo(sink);
            FunnelUtils.putList(message.key, sink);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableEntryDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 20) {
                throw new OFParseError("Wrong length: Expected to be >= 20, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int keyLength = U16.f(bb.readShort());
            U128 checksum = U128.read16Bytes(bb);
            List<OFBsnTlv> key = ChannelUtils.readList(bb, keyLength, OFBsnTlvVer14.READER);
            List<OFBsnTlv> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer14.READER);
            OFBsnGentableEntryDescStatsEntryVer14 bsnGentableEntryDescStatsEntryVer14 = new OFBsnGentableEntryDescStatsEntryVer14(checksum, key, value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableEntryDescStatsEntryVer14);
            }
            return bsnGentableEntryDescStatsEntryVer14;
        }
    }

    static class Builder
    implements OFBsnGentableEntryDescStatsEntry.Builder {
        private boolean checksumSet;
        private U128 checksum;
        private boolean keySet;
        private List<OFBsnTlv> key;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        Builder() {
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry build() {
            List<OFBsnTlv> value;
            List<OFBsnTlv> key;
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            List<OFBsnTlv> list = key = this.keySet ? this.key : DEFAULT_KEY;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            List<OFBsnTlv> list2 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnGentableEntryDescStatsEntryVer14(checksum, key, value);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableEntryDescStatsEntry.Builder {
        final OFBsnGentableEntryDescStatsEntryVer14 parentMessage;
        private boolean checksumSet;
        private U128 checksum;
        private boolean keySet;
        private List<OFBsnTlv> key;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        BuilderWithParent(OFBsnGentableEntryDescStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnGentableEntryDescStatsEntry build() {
            List value;
            List key;
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            List list = key = this.keySet ? this.key : this.parentMessage.key;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            List list2 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnGentableEntryDescStatsEntryVer14(checksum, key, value);
        }
    }
}

