/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBarrierReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBarrierReplyVer14
implements OFBarrierReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBarrierReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBarrierReplyVer14 DEFAULT = new OFBarrierReplyVer14(0L);
    static final Reader READER = new Reader();
    static final OFBarrierReplyVer14Funnel FUNNEL = new OFBarrierReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBarrierReplyVer14(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.BARRIER_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBarrierReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBarrierReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBarrierReplyVer14 other = (OFBarrierReplyVer14)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBarrierReplyVer14 other = (OFBarrierReplyVer14)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBarrierReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBarrierReplyVer14 message) {
            bb.writeByte(5);
            bb.writeByte(21);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFBarrierReplyVer14Funnel
    implements Funnel<OFBarrierReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFBarrierReplyVer14Funnel() {
        }

        public void funnel(OFBarrierReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)21);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFBarrierReply> {
        Reader() {
        }

        @Override
        public OFBarrierReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=OFType.BARRIER_REPLY(21), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBarrierReplyVer14 barrierReplyVer14 = new OFBarrierReplyVer14(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)barrierReplyVer14);
            }
            return barrierReplyVer14;
        }
    }

    static class Builder
    implements OFBarrierReply.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.BARRIER_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBarrierReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBarrierReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBarrierReplyVer14(xid);
        }
    }

    static class BuilderWithParent
    implements OFBarrierReply.Builder {
        final OFBarrierReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBarrierReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.BARRIER_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBarrierReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBarrierReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBarrierReplyVer14(xid);
        }
    }
}

