/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVrfCounterStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVrfCounterStatsEntryVer13
implements OFBsnVrfCounterStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVrfCounterStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final long DEFAULT_VRF = 0L;
    private static final List<U64> DEFAULT_VALUES = ImmutableList.of();
    private final long vrf;
    private final List<U64> values;
    static final OFBsnVrfCounterStatsEntryVer13 DEFAULT = new OFBsnVrfCounterStatsEntryVer13(0L, DEFAULT_VALUES);
    static final Reader READER = new Reader();
    static final OFBsnVrfCounterStatsEntryVer13Funnel FUNNEL = new OFBsnVrfCounterStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVrfCounterStatsEntryVer13(long vrf, List<U64> values) {
        if (values == null) {
            throw new NullPointerException("OFBsnVrfCounterStatsEntryVer13: property values cannot be null");
        }
        this.vrf = vrf;
        this.values = values;
    }

    @Override
    public long getVrf() {
        return this.vrf;
    }

    @Override
    public List<U64> getValues() {
        return this.values;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnVrfCounterStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVrfCounterStatsEntryVer13(");
        b.append("vrf=").append(this.vrf);
        b.append(", ");
        b.append("values=").append(this.values);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVrfCounterStatsEntryVer13 other = (OFBsnVrfCounterStatsEntryVer13)obj;
        if (this.vrf != other.vrf) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.vrf ^ this.vrf >>> 32);
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVrfCounterStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVrfCounterStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            bb.writeInt(U32.t(message.vrf));
            ChannelUtils.writeList(bb, message.values);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnVrfCounterStatsEntryVer13Funnel
    implements Funnel<OFBsnVrfCounterStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVrfCounterStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnVrfCounterStatsEntryVer13 message, PrimitiveSink sink) {
            sink.putLong(message.vrf);
            FunnelUtils.putList(message.values, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVrfCounterStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnVrfCounterStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            long vrf = U32.f(bb.readInt());
            List<U64> values = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U64.READER);
            OFBsnVrfCounterStatsEntryVer13 bsnVrfCounterStatsEntryVer13 = new OFBsnVrfCounterStatsEntryVer13(vrf, values);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVrfCounterStatsEntryVer13);
            }
            return bsnVrfCounterStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnVrfCounterStatsEntry.Builder {
        private boolean vrfSet;
        private long vrf;
        private boolean valuesSet;
        private List<U64> values;

        Builder() {
        }

        @Override
        public long getVrf() {
            return this.vrf;
        }

        @Override
        public OFBsnVrfCounterStatsEntry.Builder setVrf(long vrf) {
            this.vrf = vrf;
            this.vrfSet = true;
            return this;
        }

        @Override
        public List<U64> getValues() {
            return this.values;
        }

        @Override
        public OFBsnVrfCounterStatsEntry.Builder setValues(List<U64> values) {
            this.values = values;
            this.valuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnVrfCounterStatsEntry build() {
            List<U64> values;
            long vrf = this.vrfSet ? this.vrf : 0L;
            List<U64> list = values = this.valuesSet ? this.values : DEFAULT_VALUES;
            if (values == null) {
                throw new NullPointerException("Property values must not be null");
            }
            return new OFBsnVrfCounterStatsEntryVer13(vrf, values);
        }
    }

    static class BuilderWithParent
    implements OFBsnVrfCounterStatsEntry.Builder {
        final OFBsnVrfCounterStatsEntryVer13 parentMessage;
        private boolean vrfSet;
        private long vrf;
        private boolean valuesSet;
        private List<U64> values;

        BuilderWithParent(OFBsnVrfCounterStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getVrf() {
            return this.vrf;
        }

        @Override
        public OFBsnVrfCounterStatsEntry.Builder setVrf(long vrf) {
            this.vrf = vrf;
            this.vrfSet = true;
            return this;
        }

        @Override
        public List<U64> getValues() {
            return this.values;
        }

        @Override
        public OFBsnVrfCounterStatsEntry.Builder setValues(List<U64> values) {
            this.values = values;
            this.valuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnVrfCounterStatsEntry build() {
            List values;
            long vrf = this.vrfSet ? this.vrf : this.parentMessage.vrf;
            List list = values = this.valuesSet ? this.values : this.parentMessage.values;
            if (values == null) {
                throw new NullPointerException("Property values must not be null");
            }
            return new OFBsnVrfCounterStatsEntryVer13(vrf, values);
        }
    }
}

