/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVrf;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVrfVer13
implements OFBsnTlvVrf {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVrfVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvVrfVer13 DEFAULT = new OFBsnTlvVrfVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvVrfVer13Funnel FUNNEL = new OFBsnTlvVrfVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVrfVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvVrf.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVrfVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVrfVer13 other = (OFBsnTlvVrfVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVrfVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVrfVer13 message) {
            bb.writeShort(19);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvVrfVer13Funnel
    implements Funnel<OFBsnTlvVrfVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVrfVer13Funnel() {
        }

        public void funnel(OFBsnTlvVrfVer13 message, PrimitiveSink sink) {
            sink.putShort((short)19);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVrf> {
        Reader() {
        }

        @Override
        public OFBsnTlvVrf readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=0x13(0x13), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvVrfVer13 bsnTlvVrfVer13 = new OFBsnTlvVrfVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVrfVer13);
            }
            return bsnTlvVrfVer13;
        }
    }

    static class Builder
    implements OFBsnTlvVrf.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVrf.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVrf build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvVrfVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVrf.Builder {
        final OFBsnTlvVrfVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvVrfVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVrf.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVrf build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvVrfVer13(value);
        }
    }
}

