/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVirtual;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVirtualVer13
implements OFBsnTlvVirtual {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVirtualVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFBsnTlvVirtualVer13 DEFAULT = new OFBsnTlvVirtualVer13();
    static final OFBsnTlvVirtualVer13 INSTANCE = new OFBsnTlvVirtualVer13();
    static final Reader READER = new Reader();
    static final OFBsnTlvVirtualVer13Funnel FUNNEL = new OFBsnTlvVirtualVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvVirtualVer13() {
    }

    @Override
    public int getType() {
        return 158;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvVirtual.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvVirtualVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVirtualVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVirtualVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVirtualVer13 message) {
            bb.writeShort(158);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvVirtualVer13Funnel
    implements Funnel<OFBsnTlvVirtualVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVirtualVer13Funnel() {
        }

        public void funnel(OFBsnTlvVirtualVer13 message, PrimitiveSink sink) {
            sink.putShort((short)158);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVirtual> {
        Reader() {
        }

        @Override
        public OFBsnTlvVirtual readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 158) {
                throw new OFParseError("Wrong type: Expected=0x9e(0x9e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

