/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUsePacketState;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUsePacketStateVer13
implements OFBsnTlvUsePacketState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUsePacketStateVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvUsePacketStateVer13 DEFAULT = new OFBsnTlvUsePacketStateVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUsePacketStateVer13Funnel FUNNEL = new OFBsnTlvUsePacketStateVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUsePacketStateVer13(short value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 96;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUsePacketState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUsePacketStateVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUsePacketStateVer13 other = (OFBsnTlvUsePacketStateVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUsePacketStateVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUsePacketStateVer13 message) {
            bb.writeShort(96);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvUsePacketStateVer13Funnel
    implements Funnel<OFBsnTlvUsePacketStateVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUsePacketStateVer13Funnel() {
        }

        public void funnel(OFBsnTlvUsePacketStateVer13 message, PrimitiveSink sink) {
            sink.putShort((short)96);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUsePacketState> {
        Reader() {
        }

        @Override
        public OFBsnTlvUsePacketState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 96) {
                throw new OFParseError("Wrong type: Expected=0x60(0x60), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvUsePacketStateVer13 bsnTlvUsePacketStateVer13 = new OFBsnTlvUsePacketStateVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUsePacketStateVer13);
            }
            return bsnTlvUsePacketStateVer13;
        }
    }

    static class Builder
    implements OFBsnTlvUsePacketState.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 96;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUsePacketState.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUsePacketState build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvUsePacketStateVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUsePacketState.Builder {
        final OFBsnTlvUsePacketStateVer13 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvUsePacketStateVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 96;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUsePacketState.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUsePacketState build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUsePacketStateVer13(value);
        }
    }
}

