/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnUpgrade;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUpgrade;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnUpgradeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUpgradeVer13
implements OFBsnTlvUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUpgradeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnUpgrade value;
    static final Reader READER = new Reader();
    static final OFBsnTlvUpgradeVer13Funnel FUNNEL = new OFBsnTlvUpgradeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUpgradeVer13(OFBsnUpgrade value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvUpgradeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 164;
    }

    @Override
    public OFBsnUpgrade getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUpgrade.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUpgradeVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUpgradeVer13 other = (OFBsnTlvUpgradeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUpgradeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUpgradeVer13 message) {
            bb.writeShort(164);
            bb.writeShort(6);
            OFBsnUpgradeSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvUpgradeVer13Funnel
    implements Funnel<OFBsnTlvUpgradeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUpgradeVer13Funnel() {
        }

        public void funnel(OFBsnTlvUpgradeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)164);
            sink.putShort((short)6);
            OFBsnUpgradeSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUpgrade> {
        Reader() {
        }

        @Override
        public OFBsnTlvUpgrade readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 164) {
                throw new OFParseError("Wrong type: Expected=0xa4(0xa4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnUpgrade value = OFBsnUpgradeSerializerVer13.readFrom(bb);
            OFBsnTlvUpgradeVer13 bsnTlvUpgradeVer13 = new OFBsnTlvUpgradeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUpgradeVer13);
            }
            return bsnTlvUpgradeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvUpgrade.Builder {
        private boolean valueSet;
        private OFBsnUpgrade value;

        Builder() {
        }

        @Override
        public int getType() {
            return 164;
        }

        @Override
        public OFBsnUpgrade getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUpgrade.Builder setValue(OFBsnUpgrade value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUpgrade build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUpgradeVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUpgrade.Builder {
        final OFBsnTlvUpgradeVer13 parentMessage;
        private boolean valueSet;
        private OFBsnUpgrade value;

        BuilderWithParent(OFBsnTlvUpgradeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 164;
        }

        @Override
        public OFBsnUpgrade getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUpgrade.Builder setValue(OFBsnUpgrade value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUpgrade build() {
            OFBsnUpgrade value;
            OFBsnUpgrade oFBsnUpgrade = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUpgradeVer13(value);
        }
    }
}

